/*
 * Decompiled with CFR 0.152.
 */
package snownee.autochefsdelight.util;

import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class RecipeMatcher<T> {
    public List<T> inputs;
    public List<? extends Predicate<T>> tests;
    public int[] inputCapacity;
    public int[] inputUsed;
    public int[][] use;
    private final BitSet data;
    private final BitSet mask;

    public RecipeMatcher(List<T> inputs, List<? extends Predicate<T>> tests, int[] inputCapacity) {
        int i;
        this.inputs = inputs;
        this.tests = tests;
        this.inputCapacity = inputCapacity;
        this.inputUsed = new int[inputs.size()];
        this.use = new int[inputs.size()][tests.size()];
        this.data = new BitSet(inputs.size() * tests.size());
        this.mask = new BitSet(inputs.size());
        for (i = 0; i < tests.size(); ++i) {
            Predicate<T> test = tests.get(i);
            int offset = i * inputs.size();
            for (int j = 0; j < inputs.size(); ++j) {
                if (!test.test(inputs.get(j))) continue;
                this.data.set(offset + j);
            }
        }
        block2: for (i = 0; i < inputs.size(); ++i) {
            for (int j = 0; j < tests.size(); ++j) {
                if (this.data.get(j * inputs.size() + i)) continue block2;
            }
            this.inputUsed = null;
            return;
        }
        for (i = 0; i < tests.size(); ++i) {
            this.mask.clear();
            if (this.match(i)) continue;
            this.inputUsed = null;
            return;
        }
    }

    private boolean match(int test) {
        int offset = test * this.inputs.size();
        for (int i = 0; i < this.inputs.size(); ++i) {
            if (!this.data.get(offset + i) || this.mask.get(i)) continue;
            this.mask.set(i);
            if (this.inputUsed[i] < this.inputCapacity[i]) {
                this.use[i][this.inputUsed[i]] = test;
                int n = i;
                this.inputUsed[n] = this.inputUsed[n] + 1;
                return true;
            }
            for (int j = 0; j < this.inputUsed[i]; ++j) {
                if (!this.match(this.use[i][j])) continue;
                this.use[i][j] = test;
                return true;
            }
        }
        return false;
    }

    public static <T> Optional<RecipeMatcher<T>> findMatches(List<T> inputs, List<? extends Predicate<T>> tests, int[] amount) {
        RecipeMatcher<T> matcher = new RecipeMatcher<T>(inputs, tests, amount);
        return matcher.inputUsed == null ? Optional.empty() : Optional.of(matcher);
    }
}

