/*
 * Decompiled with CFR 0.152.
 */
package snownee.autochefsdelight.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.autochefsdelight.AutochefsDelight;
import snownee.autochefsdelight.mixin.RecipeWrapperAccess;
import snownee.autochefsdelight.util.CommonProxy;
import snownee.autochefsdelight.util.CookingPotDuck;
import snownee.autochefsdelight.util.DummyRecipeInput;
import snownee.autochefsdelight.util.RecipeMatcher;
import vectorwing.farmersdelight.common.block.entity.CookingPotBlockEntity;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;

@Mixin(value={CookingPotBlockEntity.class})
public abstract class CookingPotBlockEntityMixin
implements CookingPotDuck {
    @Shadow(remap=false)
    @Final
    public static Map<Item, Item> INGREDIENT_REMAINDER_OVERRIDES;
    @Shadow
    private int cookTime;
    @Shadow
    private int cookTimeTotal;
    @Unique
    @Nullable
    private RecipeMatcher<ItemStack> autochef$lastRecipeMatch;
    @Unique
    private boolean autochef$updateRecipe = true;
    @Unique
    @Nullable
    private ResourceLocation autochef$processingRecipeID;

    @Shadow(remap=false)
    protected abstract void ejectIngredientRemainder(ItemStack var1);

    @WrapOperation(method={"getMatchingRecipe"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/crafting/RecipeManager$CachedCheck;getRecipeFor(Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/world/level/Level;)Ljava/util/Optional;", remap=true)}, remap=false)
    private Optional<RecipeHolder<CookingPotRecipe>> getMatchingRecipe(RecipeManager.CachedCheck<RecipeWrapper, CookingPotRecipe> instance, RecipeInput recipeWrapper, Level level, Operation<Optional<RecipeHolder<CookingPotRecipe>>> original) {
        recipeWrapper = new DummyRecipeInput(((RecipeWrapperAccess)recipeWrapper).getInv(), this::autochef$setRecipeMatch);
        for (RecipeHolder<CookingPotRecipe> recipe : AutochefsDelight.COOKING_POT_RECIPES) {
            if (!((CookingPotRecipe)recipe.value()).matches((RecipeWrapper)recipeWrapper, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @WrapOperation(method={"cookingTick"}, at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;hasInput()Z")}, remap=false)
    private static boolean doNotFindRecipeIfInventoryUnchanged(@NotNull CookingPotBlockEntity cookingPot, Operation<Boolean> original) {
        CookingPotBlockEntityMixin pot = (CookingPotBlockEntityMixin)cookingPot;
        boolean bl = (pot.autochef$updateRecipe || pot.autochef$processingRecipeID != null) && (Boolean)original.call(new Object[]{cookingPot}) != false;
        pot.autochef$updateRecipe = false;
        return bl;
    }

    @WrapOperation(method={"cookingTick"}, at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;getMatchingRecipe(Lnet/neoforged/neoforge/items/wrapper/RecipeWrapper;)Ljava/util/Optional;")}, remap=false)
    private static Optional<RecipeHolder<CookingPotRecipe>> getProcessingRecipe(@NotNull CookingPotBlockEntity cookingPot, RecipeWrapper recipeWrapper, Operation<Optional<RecipeHolder<CookingPotRecipe>>> original) {
        CookingPotBlockEntityMixin pot = (CookingPotBlockEntityMixin)cookingPot;
        ResourceLocation lastRecipeID = pot.autochef$processingRecipeID;
        if (lastRecipeID == null || pot.cookTime + 1 >= pot.cookTimeTotal) {
            return (Optional)original.call(new Object[]{cookingPot, recipeWrapper});
        }
        return Objects.requireNonNull(cookingPot.getLevel()).getRecipeManager().byKey(lastRecipeID);
    }

    @Inject(method={"cookingTick"}, at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;processCooking(Lnet/minecraft/world/item/crafting/RecipeHolder;Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;)Z", remap=true)}, remap=false)
    private static void setProcessingRecipe(Level level, BlockPos pos, BlockState state, @NotNull CookingPotBlockEntity cookingPot, CallbackInfo ci, @Local Optional<RecipeHolder<CookingPotRecipe>> recipe) {
        CookingPotBlockEntityMixin pot = (CookingPotBlockEntityMixin)cookingPot;
        pot.autochef$processingRecipeID = recipe.orElseThrow().id();
        pot.autochef$updateRecipe = false;
    }

    @Inject(method={"processCooking"}, at={@At(value="INVOKE", target="Lvectorwing/farmersdelight/common/block/entity/CookingPotBlockEntity;setRecipeUsed(Lnet/minecraft/world/item/crafting/RecipeHolder;)V", shift=At.Shift.AFTER, remap=true)}, cancellable=true, remap=false)
    private void processCooking(RecipeHolder<CookingPotRecipe> recipe, CookingPotBlockEntity self, CallbackInfoReturnable<Boolean> ci) {
        Level level = Objects.requireNonNull(self.getLevel());
        if (this.autochef$lastRecipeMatch == null) {
            ((CookingPotRecipe)recipe.value()).matches((RecipeWrapper)new DummyRecipeInput((IItemHandler)self.getInventory(), this::autochef$setRecipeMatch), level);
            if (this.autochef$lastRecipeMatch == null) {
                return;
            }
        }
        for (int i = 0; i < this.autochef$lastRecipeMatch.inputUsed.length; ++i) {
            int used = this.autochef$lastRecipeMatch.inputUsed[i];
            if (used == 0) continue;
            ItemStack stack = (ItemStack)this.autochef$lastRecipeMatch.inputs.get(i);
            ItemStack remainder = CommonProxy.getRecipeRemainder(stack);
            if (!remainder.isEmpty()) {
                if (ItemStack.isSameItemSameComponents((ItemStack)remainder, (ItemStack)stack)) continue;
                this.ejectIngredientRemainder(remainder);
            } else {
                Item remainderItem = INGREDIENT_REMAINDER_OVERRIDES.get(stack.getItem());
                if (remainderItem != null) {
                    this.ejectIngredientRemainder(remainderItem.getDefaultInstance());
                }
            }
            stack.shrink(used);
        }
        this.autochef$lastRecipeMatch = null;
        ci.setReturnValue((Object)true);
    }

    @Override
    public void autochef$setRecipeMatch(@Nullable RecipeMatcher<ItemStack> match) {
        this.autochef$lastRecipeMatch = match;
    }

    @Override
    public void autochef$updateRecipe() {
        this.autochef$updateRecipe = true;
        this.autochef$processingRecipeID = null;
    }
}

