/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.block.wood;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MangroveRootsBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.potionstudios.biomeswevegone.BiomesWeveGone;
import net.potionstudios.biomeswevegone.PlatformHandler;
import net.potionstudios.biomeswevegone.client.particle.BWGParticles;
import net.potionstudios.biomeswevegone.world.item.BWGItems;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.plants.PottedBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.fruit.BWGFruitBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.grower.BWGTreeGrowers;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGChangingLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGFireCrackerLeaves;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGFruitLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.leaves.BWGLeavesBlock;
import net.potionstudios.biomeswevegone.world.level.block.plants.tree.sapling.BWGSaplingBlock;
import net.potionstudios.biomeswevegone.world.level.block.wood.BWGWoodSet;
import net.potionstudios.biomeswevegone.world.level.block.wood.ImbuedBlock;

public class BWGWood {
    public static final ArrayList<Supplier<? extends Block>> WOOD = new ArrayList();
    public static final ArrayList<Supplier<? extends Item>> WOOD_BLOCK_ITEMS = new ArrayList();
    public static final ArrayList<Supplier<? extends Block>> NONSET_WOOD = new ArrayList();
    public static final BWGWoodSet ASPEN = new BWGWoodSet("aspen", MapColor.QUARTZ, BWGTreeGrowers.ASPEN);
    public static final BWGWoodSet BAOBAB = new BWGWoodSet("baobab", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.BAOBAB);
    public static final BWGWoodSet BLUE_ENCHANTED = new BWGWoodSet("blue_enchanted", MapColor.COLOR_BLUE, BWGTreeGrowers.BLUE_ENCHANTED, true);
    public static final Supplier<ImbuedBlock> IMBUED_BLUE_ENCHANTED_WOOD = BWGWood.registerBlockItem("imbued_blue_enchanted_wood", () -> new ImbuedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE)));
    public static final BWGWoodSet CIKA = new BWGWoodSet("cika", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.CIKA);
    public static final BWGWoodSet CYPRESS = new BWGWoodSet("cypress", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.CYPRESS);
    public static final BWGWoodSet EBONY = new BWGWoodSet("ebony", MapColor.COLOR_BLACK, BWGTreeGrowers.EBONY);
    public static final BWGWoodSet FIR = new BWGWoodSet("fir", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.FIR);
    public static final BWGWoodSet FLORUS = new BWGWoodSet(new BlockSetType("florus"), MapColor.COLOR_GREEN, BWGWoodSet.LogStem.STEM, null, false, false, null);
    public static final BWGWoodSet GREEN_ENCHANTED = new BWGWoodSet("green_enchanted", MapColor.COLOR_LIGHT_GREEN, BWGTreeGrowers.GREEN_ENCHANTED, true);
    public static final Supplier<ImbuedBlock> IMBUED_GREEN_ENCHANTED_WOOD = BWGWood.registerBlockItem("imbued_green_enchanted_wood", () -> new ImbuedBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_LIGHT_GREEN)));
    public static final BWGWoodSet HOLLY = new BWGWoodSet("holly", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.HOLLY);
    public static final BWGWoodSet IRONWOOD = new BWGWoodSet("ironwood", MapColor.COLOR_GRAY, BWGTreeGrowers.IRONWOOD);
    public static final BWGWoodSet JACARANDA = new BWGWoodSet("jacaranda", MapColor.COLOR_PINK, BWGTreeGrowers.JACARANDA);
    public static final BWGWoodSet MAHOGANY = new BWGWoodSet("mahogany", MapColor.COLOR_PINK, BWGTreeGrowers.MAHOGANY);
    public static final BWGWoodSet MAPLE = new BWGWoodSet("maple", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.MAPLE);
    public static final BWGWoodSet PALM = new BWGWoodSet("palm", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.PALM, (TagKey<Block>)BlockTags.SAND);
    public static final BWGWoodSet PINE = new BWGWoodSet("pine", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.PINE);
    public static final BWGWoodSet RAINBOW_EUCALYPTUS = new BWGWoodSet("rainbow_eucalyptus", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.RAINBOW_EUCALYPTUS);
    public static final BWGWoodSet REDWOOD = new BWGWoodSet("redwood", MapColor.COLOR_RED, BWGTreeGrowers.REDWOOD);
    public static final BWGWoodSet SAKURA = new BWGWoodSet(BlockSetType.register((BlockSetType)new BlockSetType("sakura", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.CHERRY_WOOD, SoundEvents.CHERRY_WOOD_DOOR_CLOSE, SoundEvents.CHERRY_WOOD_DOOR_OPEN, SoundEvents.CHERRY_WOOD_TRAPDOOR_CLOSE, SoundEvents.CHERRY_WOOD_TRAPDOOR_OPEN, SoundEvents.CHERRY_WOOD_PRESSURE_PLATE_CLICK_OFF, SoundEvents.CHERRY_WOOD_PRESSURE_PLATE_CLICK_ON, SoundEvents.CHERRY_WOOD_BUTTON_CLICK_OFF, SoundEvents.CHERRY_WOOD_BUTTON_CLICK_ON)), MapColor.COLOR_RED, null, false);
    public static final PottedBlock WHITE_SAKURA_SAPLING = BWGWood.createSapling("white_sakura", BWGTreeGrowers.WHITE_SAKURA, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock YELLOW_SAKURA_SAPLING = BWGWood.createSapling("yellow_sakura", BWGTreeGrowers.YELLOW_SAKURA, (TagKey<Block>)BlockTags.DIRT);
    public static final BWGWoodSet SKYRIS = new BWGWoodSet("skyris", MapColor.COLOR_LIGHT_BLUE, BWGTreeGrowers.SKYRIS);
    public static final BWGWoodSet SPIRIT = new BWGWoodSet(BlockSetType.register((BlockSetType)new BlockSetType("spirit", true, true, true, BlockSetType.PressurePlateSensitivity.EVERYTHING, SoundType.NETHER_WOOD, SoundEvents.NETHER_WOOD_DOOR_CLOSE, SoundEvents.NETHER_WOOD_DOOR_OPEN, SoundEvents.NETHER_WOOD_TRAPDOOR_CLOSE, SoundEvents.NETHER_WOOD_TRAPDOOR_OPEN, SoundEvents.NETHER_WOOD_PRESSURE_PLATE_CLICK_OFF, SoundEvents.NETHER_WOOD_PRESSURE_PLATE_CLICK_ON, SoundEvents.NETHER_WOOD_BUTTON_CLICK_OFF, SoundEvents.NETHER_WOOD_BUTTON_CLICK_ON)), MapColor.COLOR_LIGHT_GRAY, BWGTreeGrowers.SPIRIT, false);
    public static final Supplier<MangroveRootsBlock> SPIRIT_ROOTS = BWGWood.registerBlockItem("spirit_roots", () -> new MangroveRootsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MANGROVE_ROOTS).sound(SoundType.NETHER_WOOD)));
    public static final BWGWoodSet WHITE_MANGROVE = new BWGWoodSet("white_mangrove", MapColor.TERRACOTTA_WHITE, BWGTreeGrowers.WHITE_MANGROVE);
    public static final BWGWoodSet WILLOW = new BWGWoodSet("willow", MapColor.COLOR_GREEN, BWGTreeGrowers.WILLOW);
    public static final BWGWoodSet WITCH_HAZEL = new BWGWoodSet("witch_hazel", MapColor.COLOR_GREEN, BWGTreeGrowers.WITCH_HAZEL);
    public static final BWGWoodSet ZELKOVA = new BWGWoodSet("zelkova", MapColor.COLOR_ORANGE, BWGTreeGrowers.ZELKOVA);
    public static final Supplier<RotatedPillarBlock> PALO_VERDE_LOG = BWGWood.registerBlockItem("palo_verde_log", () -> (RotatedPillarBlock)Blocks.log((MapColor)MapColor.COLOR_GREEN, (MapColor)MapColor.COLOR_GREEN));
    public static final Supplier<RotatedPillarBlock> PALO_VERDE_WOOD = BWGWood.registerBlockItem("palo_verde_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final Supplier<RotatedPillarBlock> STRIPPED_PALO_VERDE_LOG = BWGWood.registerBlockItem("stripped_palo_verde_log", () -> (RotatedPillarBlock)Blocks.log((MapColor)MapColor.COLOR_GREEN, (MapColor)MapColor.COLOR_GREEN));
    public static final Supplier<RotatedPillarBlock> STRIPPED_PALO_VERDE_WOOD = BWGWood.registerBlockItem("stripped_palo_verde_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).ignitedByLava()));
    public static final Supplier<LeavesBlock> PALO_VERDE_LEAVES = BWGWood.registerBlockItem("palo_verde_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final PottedBlock PALO_VERDE_SAPLING = BWGWood.createSapling("palo_verde", BWGTreeGrowers.PALO_VERDE, (TagKey<Block>)BlockTags.SAND);
    public static final PottedBlock ARAUCARIA_SAPLING = BWGWood.createNonSetSapling("araucaria", BWGTreeGrowers.ARAUCARIA, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock BLUE_SPRUCE_SAPLING = BWGWood.createNonSetSapling("blue_spruce", BWGTreeGrowers.BLUE_SPRUCE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock BROWN_BIRCH_SAPLING = BWGWood.createNonSetSapling("brown_birch", BWGTreeGrowers.BROWN_BIRCH, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock BROWN_OAK_SAPLING = BWGWood.createNonSetSapling("brown_oak", BWGTreeGrowers.BROWN_OAK, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock BROWN_ZELKOVA_SAPLING = BWGWood.createNonSetSapling("brown_zelkova", BWGTreeGrowers.BROWN_ZELKOVA, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock INDIGO_JACARANDA_SAPLING = BWGWood.createNonSetSapling("indigo_jacaranda", BWGTreeGrowers.INDIGO_JACARANDA, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock ORANGE_BIRCH_SAPLING = BWGWood.createNonSetSapling("orange_birch", BWGTreeGrowers.ORANGE_BIRCH, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock ORANGE_OAK_SAPLING = BWGWood.createNonSetSapling("orange_oak", BWGTreeGrowers.ORANGE_OAK, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock ORANGE_SPRUCE_SAPLING = BWGWood.createNonSetSapling("orange_spruce", BWGTreeGrowers.ORANGE_SPRUCE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock ORCHARD_SAPLING = BWGWood.createNonSetSapling("orchard", BWGTreeGrowers.ORCHARD, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock RED_BIRCH_SAPLING = BWGWood.createNonSetSapling("red_birch", BWGTreeGrowers.RED_BIRCH, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock RED_MAPLE_SAPLING = BWGWood.createNonSetSapling("red_maple", BWGTreeGrowers.RED_MAPLE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock RED_OAK_SAPLING = BWGWood.createNonSetSapling("red_oak", BWGTreeGrowers.RED_OAK, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock RED_SPRUCE_SAPLING = BWGWood.createNonSetSapling("red_spruce", BWGTreeGrowers.RED_SPRUCE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock SILVER_MAPLE_SAPLING = BWGWood.createNonSetSapling("silver_maple", BWGTreeGrowers.SILVER_MAPLE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock YELLOW_BIRCH_SAPLING = BWGWood.createNonSetSapling("yellow_birch", BWGTreeGrowers.YELLOW_BIRCH, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock YELLOW_SPRUCE_SAPLING = BWGWood.createNonSetSapling("yellow_spruce", BWGTreeGrowers.YELLOW_SPRUCE, (TagKey<Block>)BlockTags.DIRT);
    public static final PottedBlock YUCCA_SAPLING = BWGWood.createNonSetSapling("yucca", BWGTreeGrowers.YUCCA, (TagKey<Block>)BlockTags.SAND);
    public static final Supplier<LeavesBlock> ARAUCARIA_LEAVES = BWGWood.registerLeaves("araucaria", MapColor.COLOR_GREEN);
    public static final Supplier<LeavesBlock> RIPE_BAOBAB_LEAVES = BWGWood.registerLeaves("ripe_baobab", BWGBlocks.BAOBAB_FRUIT_BLOCK, MapColor.COLOR_GREEN, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_BAOBAB_LEAVES = BWGWood.registerLeaves("flowering_baobab", MapColor.COLOR_GREEN, RIPE_BAOBAB_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> BLUE_SPRUCE_LEAVES = BWGWood.registerLeaves("blue_spruce", MapColor.COLOR_LIGHT_BLUE);
    public static final Supplier<LeavesBlock> BLOOMING_WITCH_HAZEL_LEAVES = BWGWood.registerGlowingLeaves("blooming_witch_hazel", MapColor.COLOR_ORANGE);
    public static final Supplier<LeavesBlock> BROWN_BIRCH_LEAVES = BWGWood.registerLeaves("brown_birch", MapColor.COLOR_BROWN);
    public static final Supplier<LeavesBlock> BROWN_OAK_LEAVES = BWGWood.registerLeaves("brown_oak", MapColor.COLOR_BROWN);
    public static final Supplier<LeavesBlock> BROWN_ZELKOVA_LEAVES = BWGWood.registerLeaves("brown_zelkova", MapColor.COLOR_BROWN);
    public static final Supplier<LeavesBlock> RIPE_ORCHARD_LEAVES = BWGWood.registerLeaves("ripe_orchard", BWGBlocks.APPLE_FRUIT_BLOCK, MapColor.COLOR_GREEN, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_ORCHARD_LEAVES = BWGWood.registerLeaves("flowering_orchard", MapColor.COLOR_GREEN, RIPE_ORCHARD_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> FLOWERING_PALO_VERDE_LEAVES = BWGWood.registerLeaves("flowering_palo_verde", () -> ParticleTypes.SPORE_BLOSSOM_AIR, MapColor.COLOR_YELLOW);
    public static final Supplier<LeavesBlock> HOLLY_BERRY_LEAVES = BWGWood.registerLeaves("holly_berry", MapColor.TERRACOTTA_GREEN);
    public static final Supplier<LeavesBlock> INDIGO_JACARANDA_LEAVES = BWGWood.registerLeaves("indigo_jacaranda", MapColor.TERRACOTTA_BLUE);
    public static final Supplier<LeavesBlock> FLOWERING_JACARANDA_LEAVES = BWGWood.registerLeaves("flowering_jacaranda", MapColor.TERRACOTTA_PURPLE);
    public static final Supplier<LeavesBlock> FLOWERING_INDIGO_JACARANDA_LEAVES = BWGWood.registerLeaves("flowering_indigo_jacaranda", MapColor.TERRACOTTA_BLUE);
    public static final Supplier<LeavesBlock> YUCCA_LEAVES = BWGWood.registerLeaves("yucca", MapColor.COLOR_GREEN);
    public static final Supplier<LeavesBlock> RIPE_YUCCA_LEAVES = BWGWood.registerLeaves("ripe_yucca", BWGBlocks.YUCCA_FRUIT_BLOCK, MapColor.COLOR_GREEN, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_YUCCA_LEAVES = BWGWood.registerLeaves("flowering_yucca", MapColor.COLOR_GREEN, RIPE_YUCCA_LEAVES, 0.02f);
    public static final Supplier<LeavesBlock> ORANGE_BIRCH_LEAVES = BWGWood.registerLeaves("orange_birch", MapColor.COLOR_ORANGE);
    public static final Supplier<LeavesBlock> ORANGE_OAK_LEAVES = BWGWood.registerLeaves("orange_oak", MapColor.COLOR_ORANGE);
    public static final Supplier<LeavesBlock> ORANGE_SPRUCE_LEAVES = BWGWood.registerLeaves("orange_spruce", MapColor.COLOR_ORANGE);
    public static final Supplier<LeavesBlock> ORCHARD_LEAVES = BWGWood.registerLeaves("orchard", MapColor.COLOR_GREEN);
    public static final Supplier<LeavesBlock> RED_BIRCH_LEAVES = BWGWood.registerLeaves("red_birch", MapColor.COLOR_RED);
    public static final Supplier<LeavesBlock> RED_MAPLE_LEAVES = BWGWood.registerLeaves("red_maple", BWGParticles.RED_MAPLE_LEAVES, MapColor.COLOR_RED);
    public static final Supplier<LeavesBlock> RED_OAK_LEAVES = BWGWood.registerLeaves("red_oak", MapColor.COLOR_RED);
    public static final Supplier<LeavesBlock> RED_SPRUCE_LEAVES = BWGWood.registerLeaves("red_spruce", MapColor.COLOR_RED);
    public static final Supplier<LeavesBlock> SILVER_MAPLE_LEAVES = BWGWood.registerLeaves("silver_maple", BWGParticles.SILVER_MAPLE_LEAVES, MapColor.COLOR_LIGHT_GRAY);
    public static final Supplier<LeavesBlock> SPIRIT_LEAVES = BWGWood.registerNonSetBlockItem("spirit_leaves", () -> new BWGLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).mapColor(MapColor.COLOR_LIGHT_GRAY), BWGParticles.SPIRIT_LEAVES));
    public static final Supplier<LeavesBlock> FLOWERING_SPIRIT_LEAVES = BWGWood.registerNonSetBlockItem("flowering_spirit_leaves", () -> new BWGLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).lightLevel(light -> 6).mapColor(MapColor.COLOR_LIGHT_GRAY), BWGParticles.SPIRIT_LEAVES));
    public static final Supplier<LeavesBlock> SKYRIS_LEAVES_GREEN_APPLE = BWGWood.registerLeaves("green_apple_skyris", BWGBlocks.GREEN_APPLE_FRUIT_BLOCK, MapColor.COLOR_PINK, 0.04f);
    public static final Supplier<LeavesBlock> FLOWERING_SKYRIS_LEAVES = BWGWood.registerLeaves("flowering_skyris", MapColor.COLOR_PINK, SKYRIS_LEAVES_GREEN_APPLE, 0.02f);
    public static final Supplier<LeavesBlock> FLOWERING_IRONWOOD_LEAVES = BWGWood.registerLeaves("flowering_ironwood", BWGParticles.IRONWOOD_LEAVES, MapColor.COLOR_LIGHT_GREEN);
    public static final Supplier<LeavesBlock> WHITE_SAKURA_LEAVES = BWGWood.registerSakuraLeaves("white_sakura", BWGParticles.WHITE_SAKURA_LEAVES, MapColor.COLOR_LIGHT_GRAY);
    public static final Supplier<LeavesBlock> YELLOW_SAKURA_LEAVES = BWGWood.registerSakuraLeaves("yellow_sakura", BWGParticles.YELLOW_SAKURA_LEAVES, MapColor.COLOR_YELLOW);
    public static final Supplier<LeavesBlock> YELLOW_BIRCH_LEAVES = BWGWood.registerLeaves("yellow_birch", MapColor.COLOR_YELLOW);
    public static final Supplier<LeavesBlock> YELLOW_SPRUCE_LEAVES = BWGWood.registerLeaves("yellow_spruce", MapColor.COLOR_YELLOW);
    public static final Supplier<LeavesBlock> FIRECRACKER_LEAVES = BWGWood.registerNonSetBlockItem("firecracker_leaves", () -> new BWGFireCrackerLeaves(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(MapColor.COLOR_GREEN)));

    private static Supplier<LeavesBlock> registerGlowingLeaves(String key, MapColor mapColor) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(mapColor).lightLevel(state -> 8)));
    }

    private static Supplier<LeavesBlock> registerLeaves(String key, MapColor mapColor) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(mapColor)));
    }

    private static Supplier<LeavesBlock> registerLeaves(String key, Supplier<SimpleParticleType> particleType, MapColor mapColor) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(mapColor), particleType));
    }

    private static Supplier<LeavesBlock> registerSakuraLeaves(String key, Supplier<SimpleParticleType> particleType, MapColor mapColor) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_LEAVES).mapColor(mapColor), particleType));
    }

    private static Supplier<LeavesBlock> registerLeaves(String key, MapColor mapColor, Supplier<LeavesBlock> ripeLeaves, float chance) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGChangingLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(mapColor), ripeLeaves, chance));
    }

    private static Supplier<LeavesBlock> registerLeaves(String key, Supplier<BWGFruitBlock> bwgFruitBlockSupplier, MapColor mapColor, float chance) {
        return BWGWood.registerNonSetBlockItem(key + "_leaves", () -> new BWGFruitLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).mapColor(mapColor), bwgFruitBlockSupplier, chance));
    }

    protected static PottedBlock createNonSetSapling(String key, Supplier<TreeGrower> grower, TagKey<Block> ground) {
        PottedBlock sapling = BWGWood.createSapling(key, grower, ground);
        NONSET_WOOD.add(sapling.getBlockSupplier());
        NONSET_WOOD.add(sapling.getPottedBlockSupplier());
        return sapling;
    }

    protected static PottedBlock createSapling(String key, Supplier<TreeGrower> grower, TagKey<Block> ground) {
        Supplier<SaplingBlock> sapling = BWGWood.registerBlockItem(key + "_sapling", () -> new BWGSaplingBlock(ground, (TreeGrower)grower.get()));
        return new PottedBlock(sapling, BWGWood.register("potted_" + key + "_sapling", PlatformHandler.PLATFORM_HANDLER.createPottedBlock(sapling)));
    }

    private static <B extends Block> Supplier<B> registerNonSetBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGWood.register(key, blockSupplier);
        NONSET_WOOD.add(block);
        BWGWood.registerItem(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static <B extends Block> Supplier<B> registerBlockItem(String key, Supplier<B> blockSupplier) {
        Supplier block = BWGWood.register(key, blockSupplier);
        BWGWood.registerItem(key, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        return block;
    }

    protected static <B extends Block> Supplier<B> register(String id, Supplier<B> blockSupplier) {
        Supplier<B> block = BWGBlocks.register(id, blockSupplier);
        WOOD.add(block);
        return block;
    }

    protected static <I extends Item> Supplier<I> registerItem(String id, Supplier<I> item) {
        Supplier<I> supplier = BWGItems.register(id, item);
        WOOD_BLOCK_ITEMS.add(supplier);
        return supplier;
    }

    public static void wood() {
        BiomesWeveGone.LOGGER.info("Registering Oh The Biomes We've Gone Wood");
    }
}

