/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.villagerpack.VillagerPackAsDataAndResPacks;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import org.jetbrains.annotations.NotNull;

public class VillagerPackHelper {
    public static Pack createPack(final Path packPath, final String packName, PackType packType) {
        PackLocationInfo locationInfo = new PackLocationInfo("villagerpack:" + packName, (Component)Component.literal((String)("Villager Pack: " + packName)), PackSource.BUILT_IN, Optional.empty());
        return Pack.readMetaAndCreate((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){
            private VillagerPackLoader.VillagerPack villagerPack;

            @NotNull
            public PackResources openPrimary(PackLocationInfo location) {
                try {
                    this.villagerPack = new VillagerPackLoader.VillagerPack(packPath);
                    return new VillagerPackAsDataAndResPacks(this.villagerPack.getRootPath(), packName);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open villager pack: " + packName, e);
                }
            }

            @NotNull
            public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                try {
                    if (this.villagerPack == null) {
                        this.villagerPack = new VillagerPackLoader.VillagerPack(packPath);
                    }
                    return new VillagerPackAsDataAndResPacks(this.villagerPack.getRootPath(), packName);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to open villager pack: " + packName, e);
                }
            }
        }, (PackType)packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
    }

    public static boolean hasDataOrAssets(Path packPath) {
        return VillagerPackHelper.hasData(packPath) || VillagerPackHelper.hasAssets(packPath);
    }

    public static boolean hasData(Path packPath) {
        if (Files.isDirectory(packPath, new LinkOption[0])) {
            return Files.exists(packPath.resolve("data"), new LinkOption[0]);
        }
        if (packPath.toString().endsWith(".zip")) {
            try {
                VillagerPackLoader.VillagerPack pack = new VillagerPackLoader.VillagerPack(packPath);
                boolean result = pack.hasData();
                return result;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasAssets(Path packPath) {
        if (Files.isDirectory(packPath, new LinkOption[0])) {
            return Files.exists(packPath.resolve("assets"), new LinkOption[0]);
        }
        if (packPath.toString().endsWith(".zip")) {
            try {
                VillagerPackLoader.VillagerPack pack = new VillagerPackLoader.VillagerPack(packPath);
                boolean result = pack.hasAssets();
                return result;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

