/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.registry.VAPIMapDecorations;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class VillagerPackCodecs {
    private static HolderLookup.Provider registryLookup = null;

    public static void setRegistryLookup(HolderLookup.Provider lookup) {
        registryLookup = lookup;
    }

    public static ProfessionData parseProfession(JsonObject json) {
        String poiType = json.get("poi_type").getAsString();
        String workSound = json.get("work_sound").getAsString();
        String namespace = json.get("namespace").getAsString();
        return new ProfessionData(poiType, ResourceLocation.parse((String)workSound), namespace);
    }

    public static PoiTypeData parsePoiType(JsonObject json) {
        String block = json.get("block").getAsString();
        int tickets = json.has("tickets") ? json.get("tickets").getAsInt() : 1;
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new PoiTypeData(ResourceLocation.parse((String)block), tickets, namespace);
    }

    public static VillagerTypeData parseVillagerType(JsonObject json) {
        String name = json.get("name").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new VillagerTypeData(name, namespace);
    }

    public static StructureTagData parseStructureTag(JsonObject json) {
        String name = json.get("tag").getAsString();
        String decoration = json.get("map_decoration").getAsString();
        String map_color = json.get("map_color").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new StructureTagData(name, decoration, map_color, namespace);
    }

    public static WorkstationData parseWorkstation(JsonObject json) {
        String name = json.get("name").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new WorkstationData(name, namespace);
    }

    public static GiftData parseGift(JsonObject json) {
        String profession = json.get("profession").getAsString();
        String lootTable = json.get("loot_table").getAsString();
        return new GiftData(profession, ResourceLocation.parse((String)lootTable));
    }

    public static TradesData parseTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject levelsObj = json.getAsJsonObject("levels");
        Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
        for (String levelStr : levelsObj.keySet()) {
            int level = Integer.parseInt(levelStr);
            JsonArray tradesArray = levelsObj.getAsJsonArray(levelStr);
            ArrayList<VillagerTrades.ItemListing> listings = new ArrayList<VillagerTrades.ItemListing>();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject tradeObj = tradeElement.getAsJsonObject();
                VillagerTrades.ItemListing listing = VillagerPackCodecs.parseTrade(tradeObj);
                if (listing == null) continue;
                listings.add(listing);
            }
            trades.put(level, (Object)listings.toArray(new VillagerTrades.ItemListing[0]));
        }
        return new TradesData(profession, (Int2ObjectMap<VillagerTrades.ItemListing[]>)trades);
    }

    public static BiomeTradesData parseBiomeTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject biomeOverrides = json.getAsJsonObject("biome_overrides");
        HashMap<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>> biomeTradeMap = new HashMap<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
        HashMap<VillagerType, Map<Integer, Boolean>> replaceFlags = new HashMap<VillagerType, Map<Integer, Boolean>>();
        for (String biomeTypeKey : biomeOverrides.keySet()) {
            VillagerType villagerType = (VillagerType)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)biomeTypeKey));
            if (villagerType == null) {
                VillagerAPI.LOGGER.warn("Unknown villager type: {}", (Object)biomeTypeKey);
                continue;
            }
            JsonObject biomeData = biomeOverrides.getAsJsonObject(biomeTypeKey);
            JsonObject levelsObj = biomeData.getAsJsonObject("levels");
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            HashMap<Integer, Boolean> levelReplaceFlags = new HashMap<Integer, Boolean>();
            for (String levelStr : levelsObj.keySet()) {
                JsonArray tradesArray;
                int level = Integer.parseInt(levelStr);
                JsonElement levelElement = levelsObj.get(levelStr);
                boolean replace = false;
                if (levelElement.isJsonArray()) {
                    tradesArray = levelElement.getAsJsonArray();
                } else if (levelElement.isJsonObject()) {
                    JsonObject levelObj = levelElement.getAsJsonObject();
                    replace = levelObj.has("replace") && levelObj.get("replace").getAsBoolean();
                    tradesArray = levelObj.getAsJsonArray("trades");
                } else {
                    VillagerAPI.LOGGER.warn("Invalid level data format for level {} in biome {}", (Object)levelStr, (Object)biomeTypeKey);
                    continue;
                }
                ArrayList<VillagerTrades.ItemListing> listings = new ArrayList<VillagerTrades.ItemListing>();
                for (JsonElement tradeElement : tradesArray) {
                    JsonObject tradeObj = tradeElement.getAsJsonObject();
                    VillagerTrades.ItemListing listing = VillagerPackCodecs.parseTrade(tradeObj);
                    if (listing == null) continue;
                    listings.add(listing);
                }
                trades.put(level, (Object)listings.toArray(new VillagerTrades.ItemListing[0]));
                levelReplaceFlags.put(level, replace);
            }
            biomeTradeMap.put(villagerType, (Int2ObjectMap<VillagerTrades.ItemListing[]>)trades);
            replaceFlags.put(villagerType, levelReplaceFlags);
        }
        return new BiomeTradesData(profession, biomeTradeMap, replaceFlags);
    }

    private static VillagerTrades.ItemListing parseTrade(JsonObject json) {
        try {
            VillagerTrades.ItemListing vanillaTrade;
            JsonElement sellElement = json.get("sell");
            if (sellElement != null && sellElement.isJsonObject()) {
                String itemType;
                JsonObject sellObj = sellElement.getAsJsonObject();
                String string = itemType = sellObj.has("item_type") ? sellObj.get("item_type").getAsString() : "simple";
                if ("treasure_map".equals(itemType)) {
                    return VillagerPackCodecs.parseTreasureMapTrade(json, sellObj);
                }
                if ("enchanted_book".equals(itemType)) {
                    return VillagerPackCodecs.parseEnchantBookWithTagTrade(json, sellObj);
                }
                if ("suspicious_stew".equals(itemType)) {
                    return VillagerPackCodecs.parseSuspiciousStewWithEffectsTrade(json, sellObj);
                }
            }
            if ((vanillaTrade = VillagerPackCodecs.tryParseVanillaTrade(json)) != null) {
                return vanillaTrade;
            }
            return VillagerPackCodecs.parseCustomTrade(json);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to parse trade: {}", (Object)json, (Object)e);
            return null;
        }
    }

    private static VillagerTrades.ItemListing tryParseVanillaTrade(JsonObject json) {
        if (VillagerPackCodecs.hasComponents(json.get("buy_a")) || json.has("buy_b") && VillagerPackCodecs.hasComponents(json.get("buy_b")) || VillagerPackCodecs.hasComponents(json.get("sell"))) {
            return null;
        }
        if (VillagerPackCodecs.isSimpleEmeraldToItem(json)) {
            return VillagerPackCodecs.parseItemsForEmeralds(json);
        }
        if (VillagerPackCodecs.isSimpleItemToEmerald(json)) {
            return VillagerPackCodecs.parseEmeraldForItems(json);
        }
        if (VillagerPackCodecs.isItemAndEmeraldToItem(json)) {
            return VillagerPackCodecs.parseItemsAndEmeraldsToItems(json);
        }
        if (VillagerPackCodecs.isEnchantedItemTrade(json)) {
            return VillagerPackCodecs.parseEnchantedItemForEmeralds(json);
        }
        if (VillagerPackCodecs.isDyedArmorTrade(json)) {
            return VillagerPackCodecs.parseDyedArmorForEmeralds(json);
        }
        return null;
    }

    private static boolean isSimpleEmeraldToItem(JsonObject json) {
        if (!json.has("buy_a") || !json.has("sell") || json.has("buy_b")) {
            return false;
        }
        if (VillagerPackCodecs.hasComponents(json.get("buy_a")) || VillagerPackCodecs.hasComponents(json.get("sell"))) {
            return false;
        }
        return "minecraft:emerald".equals(VillagerPackCodecs.getItemId(json.get("buy_a")));
    }

    private static boolean isSimpleItemToEmerald(JsonObject json) {
        if (!json.has("buy_a") || !json.has("sell") || json.has("buy_b")) {
            return false;
        }
        if (VillagerPackCodecs.hasComponents(json.get("buy_a")) || VillagerPackCodecs.hasComponents(json.get("sell"))) {
            return false;
        }
        return "minecraft:emerald".equals(VillagerPackCodecs.getItemId(json.get("sell")));
    }

    private static boolean isItemAndEmeraldToItem(JsonObject json) {
        if (!(json.has("buy_a") && json.has("buy_b") && json.has("sell"))) {
            return false;
        }
        return "minecraft:emerald".equals(VillagerPackCodecs.getItemId(json.get("buy_b"))) && !VillagerPackCodecs.hasComponents(json.get("buy_a")) && !VillagerPackCodecs.hasComponents(json.get("sell"));
    }

    private static boolean isEnchantedItemTrade(JsonObject json) {
        if (VillagerPackCodecs.hasComponents(json.get("sell")) || !VillagerPackCodecs.isSimpleEmeraldToItem(json)) {
            return false;
        }
        String sell = VillagerPackCodecs.getItemId(json.get("sell"));
        return sell.contains("_sword") || sell.contains("_axe") || sell.contains("_pickaxe") || sell.contains("_shovel") || sell.contains("_hoe") || sell.contains("_helmet") || sell.contains("_chestplate") || sell.contains("_leggings") || sell.contains("_boots") || sell.contains("_bow") || sell.contains("trident");
    }

    private static boolean isDyedArmorTrade(JsonObject json) {
        if (!VillagerPackCodecs.isSimpleEmeraldToItem(json)) {
            return false;
        }
        String sell = VillagerPackCodecs.getItemId(json.get("sell"));
        return sell.contains("leather_") && (sell.endsWith("_helmet") || sell.endsWith("_chestplate") || sell.endsWith("_leggings") || sell.endsWith("_boots"));
    }

    private static boolean hasComponents(JsonElement element) {
        return element != null && element.isJsonObject() && element.getAsJsonObject().has("components");
    }

    private static VillagerTrades.ItemListing parseItemsForEmeralds(JsonObject json) {
        int emeraldCost = VillagerPackCodecs.getCount(json.get("buy_a"));
        String itemId = VillagerPackCodecs.getItemId(json.get("sell"));
        int itemCount = VillagerPackCodecs.getCount(json.get("sell"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        Item item = VillagerPackCodecs.getItem(itemId);
        if (item == null) {
            return null;
        }
        return new VillagerTrades.ItemsForEmeralds(item, emeraldCost, itemCount, maxUses, xp);
    }

    private static VillagerTrades.ItemListing parseEmeraldForItems(JsonObject json) {
        String itemId = VillagerPackCodecs.getItemId(json.get("buy_a"));
        int itemCount = VillagerPackCodecs.getCount(json.get("buy_a"));
        int emeraldAmount = VillagerPackCodecs.getCount(json.get("sell"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 16;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 2;
        Item item = VillagerPackCodecs.getItem(itemId);
        if (item == null) {
            return null;
        }
        return new VillagerTrades.EmeraldForItems((ItemLike)item, itemCount, maxUses, xp, emeraldAmount);
    }

    private static VillagerTrades.ItemListing parseItemsAndEmeraldsToItems(JsonObject json) {
        String buyAId = VillagerPackCodecs.getItemId(json.get("buy_a"));
        int buyACount = VillagerPackCodecs.getCount(json.get("buy_a"));
        int emeraldCost = VillagerPackCodecs.getCount(json.get("buy_b"));
        String sellId = VillagerPackCodecs.getItemId(json.get("sell"));
        int sellCount = VillagerPackCodecs.getCount(json.get("sell"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 10;
        float priceMultiplier = json.has("price_multiplier") ? json.get("price_multiplier").getAsFloat() : 0.05f;
        Item buyItem = VillagerPackCodecs.getItem(buyAId);
        Item sellItem = VillagerPackCodecs.getItem(sellId);
        if (buyItem == null || sellItem == null) {
            return null;
        }
        return new VillagerTrades.ItemsAndEmeraldsToItems((ItemLike)buyItem, buyACount, emeraldCost, sellItem, sellCount, maxUses, xp, priceMultiplier);
    }

    private static VillagerTrades.ItemListing parseEnchantedItemForEmeralds(JsonObject json) {
        String itemId = VillagerPackCodecs.getItemId(json.get("sell"));
        int emeraldCost = VillagerPackCodecs.getCount(json.get("buy_a"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 3;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 15;
        Item item = VillagerPackCodecs.getItem(itemId);
        if (item == null) {
            return null;
        }
        return new VillagerTrades.EnchantedItemForEmeralds(item, emeraldCost, maxUses, xp);
    }

    private static VillagerTrades.ItemListing parseDyedArmorForEmeralds(JsonObject json) {
        String itemId = VillagerPackCodecs.getItemId(json.get("sell"));
        int emeraldCost = VillagerPackCodecs.getCount(json.get("buy_a"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        Item item = VillagerPackCodecs.getItem(itemId);
        if (item == null) {
            return null;
        }
        return new VillagerTrades.DyedArmorForEmeralds(item, emeraldCost, maxUses, xp);
    }

    private static VillagerTrades.ItemListing parseEnchantBookWithTagTrade(JsonObject json, JsonObject sellObj) {
        int maxLevel;
        int xp;
        int n = xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        if (!sellObj.has("enchantment_tag")) {
            VillagerAPI.LOGGER.warn("EnchantBookForEmeralds requires 'enchantment_tag' in sell object");
            return null;
        }
        String tagId = sellObj.get("enchantment_tag").getAsString();
        TagKey tag = TagKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)tagId));
        int minLevel = sellObj.has("min_level") ? sellObj.get("min_level").getAsInt() : 0;
        int n2 = maxLevel = sellObj.has("max_level") ? sellObj.get("max_level").getAsInt() : Integer.MAX_VALUE;
        if (minLevel > 0 || maxLevel < Integer.MAX_VALUE) {
            return new VillagerTrades.EnchantBookForEmeralds(xp, minLevel, maxLevel, tag);
        }
        return new VillagerTrades.EnchantBookForEmeralds(xp, tag);
    }

    private static VillagerTrades.ItemListing parseSuspiciousStewWithEffectsTrade(JsonObject json, JsonObject sellObj) {
        int xp;
        int n = xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        if (!sellObj.has("effect")) {
            return new VillagerTrades.SuspiciousStewForEmerald(MobEffects.NIGHT_VISION, 100, xp);
        }
        String effectId = sellObj.get("effect").getAsString();
        int duration = sellObj.has("duration") ? sellObj.get("duration").getAsInt() : 100;
        Holder effect = BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effectId)).orElse(null);
        if (effect == null) {
            effect = MobEffects.ABSORPTION;
        }
        return new VillagerTrades.SuspiciousStewForEmerald(effect, duration, xp);
    }

    private static VillagerTrades.ItemListing parseTreasureMapTrade(JsonObject json, JsonObject sellObj) {
        int emeraldCost = VillagerPackCodecs.getCount(json.get("buy_a"));
        String structureTag = sellObj.get("structure_tag").getAsString();
        String displayName = sellObj.get("display_name").getAsString();
        String mapDecorationInput = sellObj.get("map_decoration").getAsString();
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 5;
        TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)structureTag));
        Holder<MapDecorationType> decoration = VillagerPackCodecs.resolveMapDecoration(mapDecorationInput);
        if (decoration == null) {
            VillagerAPI.LOGGER.error("Map decoration not found: {} - skipping trade", (Object)mapDecorationInput);
            return null;
        }
        return new VillagerTrades.TreasureMapForEmeralds(emeraldCost, tag, displayName, decoration, maxUses, xp);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Holder<@NotNull MapDecorationType> resolveMapDecoration(String decorationInput) {
        Supplier<MapDecorationType> dynamicDecoration = VAPIMapDecorations.getDynamicMapDecorationType(decorationInput);
        if (dynamicDecoration != null) {
            MapDecorationType decorationType = dynamicDecoration.get();
            return BuiltInRegistries.MAP_DECORATION_TYPE.wrapAsHolder((Object)decorationType);
        }
        ResourceLocation decorationLoc = ResourceLocation.parse((String)decorationInput);
        @NotNull ResourceKey decorationKey = ResourceKey.create((ResourceKey)Registries.MAP_DECORATION_TYPE, (ResourceLocation)decorationLoc);
        return BuiltInRegistries.MAP_DECORATION_TYPE.getHolder(decorationKey).orElse(null);
    }

    private static VillagerTrades.ItemListing parseCustomTrade(JsonObject json) {
        ItemStack buyA = VillagerPackCodecs.parseItemStack(json.get("buy_a"));
        ItemStack buyB = json.has("buy_b") ? VillagerPackCodecs.parseItemStack(json.get("buy_b")) : ItemStack.EMPTY;
        ItemStack sell = VillagerPackCodecs.parseItemStack(json.get("sell"));
        if (buyA.isEmpty() || sell.isEmpty()) {
            VillagerAPI.LOGGER.error("Custom trade has empty stacks - invalid item IDs");
            return null;
        }
        final int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        final int xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        final float priceMultiplier = json.has("price_multiplier") ? json.get("price_multiplier").getAsFloat() : 0.05f;
        final boolean buyAHasComponents = json.get("buy_a").isJsonObject() && json.getAsJsonObject("buy_a").has("components");
        final boolean buyBHasComponents = json.has("buy_b") && json.get("buy_b").isJsonObject() && json.getAsJsonObject("buy_b").has("components");
        final ResourceLocation buyAId = BuiltInRegistries.ITEM.getKey((Object)buyA.getItem());
        final ResourceLocation buyBId = buyB.isEmpty() ? null : BuiltInRegistries.ITEM.getKey((Object)buyB.getItem());
        final ResourceLocation sellId = BuiltInRegistries.ITEM.getKey((Object)sell.getItem());
        final int buyACount = buyA.getCount();
        final int buyBCount = buyB.getCount();
        final int sellCount = sell.getCount();
        final CompoundTag buyAComponents = buyAHasComponents ? VillagerPackCodecs.serializeComponents(buyA) : null;
        final CompoundTag buyBComponents = buyBHasComponents ? VillagerPackCodecs.serializeComponents(buyB) : null;
        final CompoundTag sellComponents = VillagerPackCodecs.serializeComponents(sell);
        final HolderLookup.Provider capturedRegistry = registryLookup;
        return new VillagerTrades.ItemListing(){

            public MerchantOffer getOffer(@NotNull Entity entity, @NotNull RandomSource random) {
                ItemStack freshBuyA = VillagerPackCodecs.recreateStack(buyAId, buyACount, buyAComponents, capturedRegistry);
                ItemStack freshBuyB = buyBId != null ? VillagerPackCodecs.recreateStack(buyBId, buyBCount, buyBComponents, capturedRegistry) : ItemStack.EMPTY;
                ItemStack freshSell = VillagerPackCodecs.recreateStack(sellId, sellCount, sellComponents, capturedRegistry);
                if (freshBuyA.isEmpty() || freshSell.isEmpty()) {
                    return null;
                }
                ItemCost costA = new ItemCost(freshBuyA.getItemHolder(), freshBuyA.getCount(), buyAHasComponents ? DataComponentPredicate.allOf((DataComponentMap)freshBuyA.getComponents()) : DataComponentPredicate.EMPTY);
                Optional costB = freshBuyB.isEmpty() ? Optional.empty() : Optional.of(new ItemCost(freshBuyB.getItemHolder(), freshBuyB.getCount(), buyBHasComponents ? DataComponentPredicate.allOf((DataComponentMap)freshBuyB.getComponents()) : DataComponentPredicate.EMPTY));
                return new MerchantOffer(costA, costB, freshSell, maxUses, xp, priceMultiplier);
            }
        };
    }

    private static String getItemId(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return element.getAsString();
        }
        return element.getAsJsonObject().get("item").getAsString();
    }

    private static int getCount(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return 1;
        }
        JsonObject obj = element.getAsJsonObject();
        return obj.has("count") ? obj.get("count").getAsInt() : 1;
    }

    private static Item getItem(String itemId) {
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
        if (item == null || item == Items.AIR) {
            VillagerAPI.LOGGER.error("Item {} not found during trade registration", (Object)itemId);
            return null;
        }
        return item;
    }

    private static ItemStack parseItemStack(JsonElement element) {
        Item item;
        String itemId = VillagerPackCodecs.getItemId(element);
        int count = VillagerPackCodecs.getCount(element);
        JsonObject components = null;
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonObject jsonObject = components = obj.has("components") ? obj.getAsJsonObject("components") : null;
        }
        if ((item = VillagerPackCodecs.getItem(itemId)) == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (components != null) {
            VillagerPackCodecs.applyComponentData(stack, components);
        }
        return stack;
    }

    private static CompoundTag serializeComponents(ItemStack stack) {
        if (registryLookup == null) {
            return new CompoundTag();
        }
        RegistryOps registryOps = registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        return DataComponentPatch.CODEC.encodeStart((DynamicOps)registryOps, (Object)stack.getComponentsPatch()).resultOrPartial(arg_0 -> ((Logger)VillagerAPI.LOGGER).error(arg_0)).orElse(new CompoundTag());
    }

    private static ItemStack recreateStack(ResourceLocation itemId, int count, CompoundTag components, HolderLookup.Provider registry) {
        Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
        if (item == null || item == Items.AIR) {
            VillagerAPI.LOGGER.warn("Item {} not found during trade recreation", (Object)itemId);
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (components != null && !components.isEmpty() && registry != null) {
            RegistryOps registryOps = registry.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            DataComponentPatch patch = DataComponentPatch.CODEC.parse((DynamicOps)registryOps, (Object)components).resultOrPartial(arg_0 -> ((Logger)VillagerAPI.LOGGER).error(arg_0)).orElse(DataComponentPatch.EMPTY);
            stack.applyComponents(patch);
        }
        return stack;
    }

    private static void applyComponentData(ItemStack stack, JsonObject componentsObj) {
        if (registryLookup == null) {
            VillagerAPI.LOGGER.error("Registry lookup not available for component parsing");
            return;
        }
        try {
            RegistryOps registryOps = registryLookup.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            DataComponentPatch patch = DataComponentPatch.CODEC.parse((DynamicOps)registryOps, (Object)componentsObj).resultOrPartial(error -> VillagerAPI.LOGGER.error("Failed to parse components: {}", error)).orElse(DataComponentPatch.EMPTY);
            if (!patch.isEmpty()) {
                stack.applyComponents(patch);
            }
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to apply component data", (Throwable)e);
        }
    }

    public record ProfessionData(String poiType, ResourceLocation workSound, String namespace) {
    }

    public record PoiTypeData(ResourceLocation block, int tickets, String namespace) {
    }

    public record VillagerTypeData(String name, String namespace) {
    }

    public record StructureTagData(String name, String decoration, String map_color, String namespace) {
    }

    public record WorkstationData(String name, String namespace) {
    }

    public record GiftData(String profession, ResourceLocation lootTable) {
    }

    public record TradesData(String profession, Int2ObjectMap<VillagerTrades.ItemListing[]> trades) {
    }

    public record BiomeTradesData(String profession, Map<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>> biomeTradeMap, Map<VillagerType, Map<Integer, Boolean>> replaceFlags) {
    }
}

