/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.villagerpack.BiomeMappingCache;
import com.frikinjay.villagerapi.villagerpack.BiomeTradesCache;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;

public class VillagerPackBiomeMapper {
    public static void registerBiomeMappings(Map<String, JsonObject> data, MinecraftServer server) {
        if (data.isEmpty()) {
            VillagerAPI.LOGGER.debug("No biome mappings to register");
            return;
        }
        BiomeMappingCache.clear();
        BiomeTradesCache.clear();
        Registry villagerTypeRegistry = (Registry)server.registryAccess().registry(Registries.VILLAGER_TYPE).orElseThrow();
        int registered = 0;
        for (Map.Entry<String, JsonObject> entry : data.entrySet()) {
            try {
                JsonObject mappings = entry.getValue();
                if (!mappings.has("biomes")) {
                    VillagerAPI.LOGGER.warn("Biome mapping file {} has no 'biomes' field", (Object)entry.getKey());
                    continue;
                }
                JsonObject biomes = mappings.getAsJsonObject("biomes");
                for (String biomeKey : biomes.keySet()) {
                    String villagerTypeId = biomes.get(biomeKey).getAsString();
                    ResourceKey biomeResourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)biomeKey));
                    VillagerType villagerType = (VillagerType)villagerTypeRegistry.get(ResourceLocation.parse((String)villagerTypeId));
                    if (villagerType == null) {
                        VillagerAPI.LOGGER.warn("Villager type {} not found for biome mapping", (Object)villagerTypeId);
                        continue;
                    }
                    BiomeMappingCache.registerMapping((ResourceKey<Biome>)biomeResourceKey, villagerType);
                    ++registered;
                    VillagerAPI.LOGGER.debug("Mapped biome {} to villager type {}", (Object)biomeKey, (Object)villagerTypeId);
                }
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to process biome mapping: {}", (Object)entry.getKey(), (Object)e);
            }
        }
        VillagerAPI.LOGGER.info("Registered {} biome-to-villager-type mappings from villagerpacks", (Object)registered);
    }
}

