/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerPackAsDataAndResPacks
implements PackResources {
    private final Path rootPath;
    private final String packName;
    private final PackLocationInfo locationInfo;
    private final Map<String, Path> namespacePaths = new HashMap<String, Path>();

    public VillagerPackAsDataAndResPacks(Path rootPath, String packName) {
        this.rootPath = rootPath;
        this.packName = packName;
        this.locationInfo = new PackLocationInfo("villagerpack:" + packName, (Component)Component.literal((String)("Villager Pack: " + packName)), PackSource.BUILT_IN, Optional.empty());
        this.indexNamespaces();
    }

    private void indexNamespaces() {
        Path dataPath = this.rootPath.resolve("data");
        if (!Files.exists(dataPath, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataPath);){
            for (Path namespacePath : stream) {
                if (!Files.isDirectory(namespacePath, new LinkOption[0])) continue;
                String namespace = namespacePath.getFileName().toString();
                this.namespacePaths.put(namespace, namespacePath);
            }
            VillagerAPI.LOGGER.info("Indexed {} namespaces in villagerpack: {}", (Object)this.namespacePaths.size(), (Object)this.packName);
        }
        catch (IOException e) {
            VillagerAPI.LOGGER.error("Failed to index namespaces for pack: {}", (Object)this.packName, (Object)e);
        }
    }

    public IoSupplier<InputStream> getRootResource(String ... paths) {
        Path filePath = this.rootPath;
        for (String path : paths) {
            filePath = filePath.resolve(path);
        }
        Path finalPath = filePath;
        if (Files.exists(finalPath, new LinkOption[0])) {
            return () -> Files.newInputStream(finalPath, new OpenOption[0]);
        }
        return null;
    }

    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation location) {
        String typeFolder = packType == PackType.CLIENT_RESOURCES ? "assets" : "data";
        Path resourcePath = this.rootPath.resolve(typeFolder).resolve(location.getNamespace()).resolve(location.getPath());
        if (Files.exists(resourcePath, new LinkOption[0])) {
            return () -> Files.newInputStream(resourcePath, new OpenOption[0]);
        }
        return null;
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        String typeFolder = packType == PackType.CLIENT_RESOURCES ? "assets" : "data";
        Path basePath = this.rootPath.resolve(typeFolder).resolve(namespace).resolve(path);
        if (!Files.exists(basePath, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(basePath, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                Path relativePath = this.rootPath.resolve(typeFolder).resolve(namespace).relativize((Path)file);
                String resourcePath = relativePath.toString().replace('\\', '/');
                ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)resourcePath);
                IoSupplier supplier = () -> Files.newInputStream(file, new OpenOption[0]);
                resourceOutput.accept((Object)loc, (Object)supplier);
            });
        }
        catch (IOException e) {
            VillagerAPI.LOGGER.error("Failed to list resources for {}/{} in pack {}", new Object[]{namespace, path, this.packName, e});
        }
    }

    @NotNull
    public Set<String> getNamespaces(PackType packType) {
        String typeFolder = packType == PackType.CLIENT_RESOURCES ? "assets" : "data";
        Path typePath = this.rootPath.resolve(typeFolder);
        if (!Files.exists(typePath, new LinkOption[0])) {
            return Set.of();
        }
        HashSet<String> namespaces = new HashSet<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(typePath);){
            for (Path path : stream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                namespaces.add(path.getFileName().toString());
            }
        }
        catch (IOException e) {
            VillagerAPI.LOGGER.error("Failed to get namespaces for pack: {}", (Object)this.packName, (Object)e);
        }
        return namespaces;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public <T> T getMetadataSection(MetadataSectionSerializer<T> deserializer) {
        Path metaFile = this.rootPath.resolve("pack.mcmeta");
        if (!Files.exists(metaFile, new LinkOption[0])) {
            return null;
        }
        try (InputStream stream = Files.newInputStream(metaFile, new OpenOption[0]);){
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)).getAsJsonObject();
            if (!json.has(deserializer.getMetadataSectionName())) {
                T t = null;
                return t;
            }
            JsonElement section = json.get(deserializer.getMetadataSectionName());
            Object object = deserializer.fromJson(section.getAsJsonObject());
            return (T)object;
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to read pack.mcmeta for pack: {}", (Object)this.packName, (Object)e);
            return null;
        }
    }

    @NotNull
    public PackLocationInfo location() {
        return this.locationInfo;
    }

    public void close() {
    }

    public String getPackName() {
        return this.packName;
    }
}

