/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import com.frikinjay.villagerapi.registry.VAPIGifts;
import com.frikinjay.villagerapi.registry.VAPIMapDecorations;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.registry.VAPIProfessions;
import com.frikinjay.villagerapi.registry.VAPITypes;
import com.frikinjay.villagerapi.registry.VAPIWorkstations;
import com.frikinjay.villagerapi.villagerpack.VillagerPackBiomeMapper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackLoader;
import com.frikinjay.villagerapi.villagerpack.VillagerPackRegistry;
import com.frikinjay.villagerapi.villagerpack.VillagerPackValidator;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.MinecraftServer;

public class PackInitializationOrchestrator {
    private static VillagerPackLoader packLoader;
    private static Map<VillagerPackLoader.DataType, Map<String, JsonObject>> packData;

    public static void initializeEarly() {
        Path villagerPacksDir = CommonPlatformHelper.getGameDirectory().resolve("villagerpacks");
        VillagerPackValidator.validateAllPacks(villagerPacksDir);
        packLoader = new VillagerPackLoader(CommonPlatformHelper.getGameDirectory());
        VillagerPackRegistry.registerCreativeTabsFromPacks(packLoader);
        packData = packLoader.loadAllPacks();
        VAPIWorkstations.init();
        VAPIPoiTypes.init();
        VAPITypes.init();
        VAPIMapDecorations.init();
        VAPIProfessions.init();
        VAPIGifts.init();
        VAPICreativeTabs.init();
        VillagerAPI.LOGGER.info("Early pack initialization complete");
    }

    public static void registerContent() {
        PackInitializationOrchestrator.registerWorkstations();
        PackInitializationOrchestrator.registerVillagerTypes();
        PackInitializationOrchestrator.registerMapDecorationTypes();
        PackInitializationOrchestrator.registerStructureTags();
        PackInitializationOrchestrator.registerPoiTypes();
        PackInitializationOrchestrator.registerProfessions();
        PackInitializationOrchestrator.registerGifts();
        VillagerAPI.LOGGER.info("Content registration complete");
    }

    public static void onServerStarting(MinecraftServer server) {
        VillagerPackRegistry.validateRegistrations();
        PackInitializationOrchestrator.registerBiomeMappings(server);
        VillagerAPI.LOGGER.info("Server starting initialization complete");
    }

    public static void onServerStarted(MinecraftServer server, HolderLookup.Provider registryAccess) {
        PackInitializationOrchestrator.registerTrades(registryAccess);
        PackInitializationOrchestrator.registerBiomeTrades(registryAccess);
        VAPIGifts.applyAllGifts();
        VillagerAPI.LOGGER.info("VillagerAPI initialization complete!");
    }

    private static void registerWorkstations() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.WORKSTATIONS);
        VillagerPackRegistry.registerWorkstations(data != null ? data : Map.of());
    }

    private static void registerVillagerTypes() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.TYPES);
        VillagerPackRegistry.registerVillagerTypes(data != null ? data : Map.of());
    }

    private static void registerMapDecorationTypes() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.STRUCTURE_TAGS);
        VillagerPackRegistry.registerMapDecorationTypes(data != null ? data : Map.of());
    }

    private static void registerStructureTags() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.STRUCTURE_TAGS);
        VillagerPackRegistry.registerStructureTags(data != null ? data : Map.of());
    }

    private static void registerPoiTypes() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.POI_TYPES);
        VillagerPackRegistry.registerPoiTypes(data != null ? data : Map.of());
    }

    private static void registerProfessions() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.PROFESSIONS);
        VillagerPackRegistry.registerProfessions(data != null ? data : Map.of());
    }

    private static void registerGifts() {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.GIFTS);
        VillagerPackRegistry.registerGifts(data != null ? data : Map.of());
    }

    private static void registerBiomeMappings(MinecraftServer server) {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.BIOME_MAPPINGS);
        if (data != null && !data.isEmpty()) {
            VillagerPackBiomeMapper.registerBiomeMappings(data, server);
        }
    }

    private static void registerTrades(HolderLookup.Provider registryAccess) {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.TRADES);
        VillagerPackRegistry.registerTrades(data != null ? data : Map.of(), registryAccess);
    }

    private static void registerBiomeTrades(HolderLookup.Provider registryAccess) {
        Map<String, JsonObject> data = packData.get((Object)VillagerPackLoader.DataType.BIOME_TRADES);
        VillagerPackRegistry.registerBiomeTrades(data != null ? data : Map.of(), registryAccess);
    }

    public static VillagerPackLoader getPackLoader() {
        return packLoader;
    }

    public static Map<VillagerPackLoader.DataType, Map<String, JsonObject>> getPackData() {
        return packData;
    }
}

