/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.level.biome.Biome;

public class BiomeMappingCache {
    private static final Map<ResourceKey<Biome>, VillagerType> BIOME_MAPPINGS = new HashMap<ResourceKey<Biome>, VillagerType>();

    public static void registerMapping(ResourceKey<Biome> biome, VillagerType villagerType) {
        BIOME_MAPPINGS.put(biome, villagerType);
        VillagerAPI.LOGGER.debug("Registered biome mapping: {} -> {}", (Object)biome.location(), (Object)villagerType);
    }

    public static VillagerType getVillagerTypeForBiome(ResourceKey<Biome> biome) {
        return BIOME_MAPPINGS.get(biome);
    }

    public static void clear() {
        BIOME_MAPPINGS.clear();
        VillagerAPI.LOGGER.info("Cleared biome mappings cache");
    }

    public static Map<ResourceKey<Biome>, VillagerType> getAllMappings() {
        return new HashMap<ResourceKey<Biome>, VillagerType>(BIOME_MAPPINGS);
    }

    public static int size() {
        return BIOME_MAPPINGS.size();
    }
}

