/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.RegistryHelper;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class VAPIWorkstations {
    private static final RegistryHelper.DynamicRegistry<Block> WORKSTATIONS = new RegistryHelper.DynamicRegistry("workstations");

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.WorkstationData workstationData = VillagerPackCodecs.parseWorkstation(json);
            String registryName = RegistryHelper.sanitizeRegistryName(name);
            String namespace = RegistryHelper.getNamespace(json, "villagerapi");
            Supplier<Block> block = CommonPlatformHelper.registerWorkstationBlock(namespace, registryName, () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CARTOGRAPHY_TABLE)));
            CommonPlatformHelper.registerWorkstationItem(namespace, registryName, () -> new BlockItem((Block)block.get(), new Item.Properties()));
            WORKSTATIONS.register(name, block);
            VAPIWorkstations.addToCreativeTab(json, registryName, namespace, block);
            VillagerAPI.LOGGER.info("Registered villager workstation from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register villager workstation from pack: {}", (Object)name, (Object)e);
        }
    }

    private static void addToCreativeTab(JsonObject json, String registryName, String namespace, Supplier<Block> block) {
        if (json.has("_pack_namespace")) {
            String packNamespace = json.get("_pack_namespace").getAsString();
            VAPICreativeTabs.addWorkstationToTab(packNamespace, block);
            VillagerAPI.LOGGER.debug("Added workstation '{}' to creative tab for pack '{}'", (Object)registryName, (Object)packNamespace);
        }
    }

    public static Supplier<Block> getDynamicWorkstation(String name) {
        return WORKSTATIONS.get(name);
    }

    public static Map<String, Supplier<Block>> getDynamicWorkstations() {
        return WORKSTATIONS.getAll();
    }
}

