/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;

public class VAPIStructureTags {
    private static final Map<String, TagKey<Structure>> DYNAMIC_STRUCTURE_TAGS = new HashMap<String, TagKey<Structure>>();

    public static void init() {
    }

    public static void registerFromPack(String tagName, JsonObject json) {
        try {
            VillagerPackCodecs.StructureTagData tagData = VillagerPackCodecs.parseStructureTag(json);
            String registryName = tagName.replace("/", "_");
            String namespace = tagData.namespace() != null ? tagData.namespace() : "villagerapi";
            TagKey structureTag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)new ResourceLocation(namespace, registryName));
            DYNAMIC_STRUCTURE_TAGS.put(tagName, (TagKey<Structure>)structureTag);
            VillagerAPI.LOGGER.info("Created structure tag from pack: {}", (Object)structureTag);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to create structure tag from pack: {}", (Object)tagName, (Object)e);
        }
    }

    public static TagKey<Structure> getDynamicStructureTag(String tag) {
        return DYNAMIC_STRUCTURE_TAGS.get(tag);
    }

    public static Map<String, TagKey<Structure>> getDynamicStructureTags() {
        return new HashMap<String, TagKey<Structure>>(DYNAMIC_STRUCTURE_TAGS);
    }
}

