/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.mixin.PoiTypesInvoker;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class VAPIPoiTypes {
    private static final Map<String, Supplier<PoiType>> DYNAMIC_POI_TYPES = new HashMap<String, Supplier<PoiType>>();
    private static final Map<String, ResourceLocation> POI_BLOCK_IDS = new HashMap<String, ResourceLocation>();
    private static final Set<ResourceLocation> PACK_REGISTERED_POI_IDS = new HashSet<ResourceLocation>();

    public static void init() {
    }

    public static ResourceLocation registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.PoiTypeData poiData = VillagerPackCodecs.parsePoiType(json);
            String registryName = name.replace("/", "_");
            String namespace = poiData.namespace() != null ? poiData.namespace() : "villagerapi";
            ResourceLocation poiId = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)registryName);
            POI_BLOCK_IDS.put(name, poiData.block());
            Supplier<PoiType> poiType = CommonPlatformHelper.registerPoiType(namespace, registryName, () -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(poiData.block());
                if (block == null || block == Blocks.AIR) {
                    VillagerAPI.LOGGER.warn("Block {} not found for POI type {}, using empty block state set", (Object)poiData.block(), (Object)registryName);
                    return Collections.emptySet();
                }
                return PoiTypesInvoker.invokeGetBlockStates(block);
            });
            DYNAMIC_POI_TYPES.put(name, poiType);
            PACK_REGISTERED_POI_IDS.add(poiId);
            VillagerAPI.LOGGER.info("Registered POI type from pack: {} with namespace: {}", (Object)name, (Object)namespace);
            return poiId;
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register POI type from pack: {}", (Object)name, (Object)e);
            return null;
        }
    }

    public static void validatePoiTypes() {
        int valid = 0;
        int invalid = 0;
        for (Map.Entry<String, ResourceLocation> entry : POI_BLOCK_IDS.entrySet()) {
            String name = entry.getKey();
            ResourceLocation blockId = entry.getValue();
            Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
            if (block == null || block == Blocks.AIR) {
                ++invalid;
                VillagerAPI.LOGGER.warn("POI type '{}' references missing block {} - profession will not work", (Object)name, (Object)blockId);
                continue;
            }
            ++valid;
            VillagerAPI.LOGGER.debug("POI type '{}' validated with block {}", (Object)name, (Object)blockId);
        }
        if (valid > 0 || invalid > 0) {
            VillagerAPI.LOGGER.info("POI type validation: {} valid, {} invalid", (Object)valid, (Object)invalid);
        }
    }

    public static boolean isPackRegisteredPoi(ResourceLocation id) {
        return PACK_REGISTERED_POI_IDS.contains(id);
    }

    public static Supplier<PoiType> getDynamicPoiType(String name) {
        return DYNAMIC_POI_TYPES.get(name);
    }

    public static Map<String, Supplier<PoiType>> getDynamicPoiTypes() {
        return new HashMap<String, Supplier<PoiType>>(DYNAMIC_POI_TYPES);
    }
}

