/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.mixin;

import com.frikinjay.villagerapi.VillagerAPI;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={VillagerTrades.EmeraldsForVillagerTypeItem.class})
public class EmeraldsForVillagerTypeItemMixin {
    @ModifyVariable(method={"<init>(IIILjava/util/Map;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private static Map<ResourceKey<@NotNull VillagerType>, Item> addMissingVillagerTypes(Map<ResourceKey<@NotNull VillagerType>, Item> originalTrades) {
        Item plainsItem = originalTrades.get(VillagerType.PLAINS);
        if (plainsItem == null) {
            VillagerAPI.LOGGER.warn("PLAINS villager type not found in EmeraldsForVillagerTypeItem trade map, cannot add fallbacks");
            return originalTrades;
        }
        HashMap<ResourceKey<@NotNull VillagerType>, Item> expandedTrades = new HashMap<ResourceKey<VillagerType>, Item>(originalTrades);
        int addedCount = 0;
        for (ResourceKey typeKey : BuiltInRegistries.VILLAGER_TYPE.registryKeySet()) {
            if (expandedTrades.containsKey(typeKey)) continue;
            expandedTrades.put((ResourceKey<VillagerType>)typeKey, plainsItem);
            ++addedCount;
            VillagerAPI.LOGGER.debug("Added fallback PLAINS item for custom villager type: {}", (Object)typeKey.location());
        }
        if (addedCount > 0) {
            VillagerAPI.LOGGER.info("Added {} custom villager type(s) to Fisherman level 5 trade with PLAINS fallback", (Object)addedCount);
        }
        return expandedTrades;
    }
}

