/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips.foundation.data;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import toni.immersivetips.ImmersiveTips;
import toni.immersivetips.foundation.ImmersiveTip;
import toni.immersivetips.foundation.TipsResourceReloadListener;
import toni.immersivetips.foundation.config.AllConfigs;
import toni.lib.utils.VersionUtils;

public class RemoteTipConfig {
    String id;
    List<String> tooltipLines;
    String modId;
    String itemName;
    List<String> tags;
    String title;
    String condition;
    String priority;

    public static void fetchAndParseJson(String url) {
        try {
            String jsonResponse = RemoteTipConfig.fetchJson(url);
            Gson gson = new Gson();
            Type listType = new TypeToken<List<RemoteTipConfig>>(){}.getType();
            List remoteTipConfigs = (List)gson.fromJson(jsonResponse, listType);
            Minecraft.getInstance().execute(() -> RemoteTipConfig.loadTips(remoteTipConfigs));
        }
        catch (JsonSyntaxException | IOException | InterruptedException e) {
            ImmersiveTips.LOGGER.error(e.getMessage());
        }
    }

    private static String fetchJson(String url) throws IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            ImmersiveTips.LOGGER.error("Failed to fetch JSON: HTTP " + response.statusCode());
            return null;
        }
        return response.body();
    }

    public static void loadTips(List<RemoteTipConfig> list) {
        int count = 0;
        int errors = 0;
        for (RemoteTipConfig tip : list) {
            try {
                if (tip.priority != null) {
                    if (!((Boolean)AllConfigs.client().enableRemoteLoadingTips.get()).booleanValue()) continue;
                    ImmersiveTips.RemoteTips.add(new ImmersiveTip(Optional.of(tip.title == null ? "Tip" : tip.title), Optional.of(String.join((CharSequence)"\n", tip.tooltipLines)), Optional.ofNullable(tip.condition), Optional.ofNullable(null), Optional.of(Float.valueOf(15.0f)), Optional.of(-1), Optional.of(ImmersiveTip.Priority.valueOf(tip.priority))));
                } else {
                    if (!((Boolean)AllConfigs.client().enableRemoteItemTips.get()).booleanValue()) continue;
                    ImmersiveTips.ItemTooltips.computeIfAbsent(VersionUtils.resource((String)tip.modId, (String)tip.itemName), k -> new ArrayList()).addAll(tip.tooltipLines.stream().map(RemoteTipConfig::translateWithStyle).toList());
                }
                ++count;
            }
            catch (Exception e) {
                ImmersiveTips.LOGGER.error(e.getMessage());
                ++errors;
            }
        }
        TipsResourceReloadListener.loadEnabledTips();
        ImmersiveTips.LOGGER.info("Loaded " + count + " tips (" + errors + " errors)");
    }

    public static Component translateWithStyle(String text) {
        MutableComponent rootComponent = Component.literal((String)"");
        String[] parts = text.split("\u00a7");
        Style currentStyle = Style.EMPTY;
        for (String part : parts) {
            if (part.isEmpty()) continue;
            char code = part.charAt(0);
            String content = part.substring(1);
            switch (code) {
                case '0': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#000000").getOrThrow());
                    break;
                }
                case '1': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#0000AA").getOrThrow());
                    break;
                }
                case '2': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#00AA00").getOrThrow());
                    break;
                }
                case '3': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#00AAAA").getOrThrow());
                    break;
                }
                case '4': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#AA0000").getOrThrow());
                    break;
                }
                case '5': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#AA00AA").getOrThrow());
                    break;
                }
                case '6': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#FFAA00").getOrThrow());
                    break;
                }
                case '7': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#AAAAAA").getOrThrow());
                    break;
                }
                case '8': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#555555").getOrThrow());
                    break;
                }
                case '9': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#5555FF").getOrThrow());
                    break;
                }
                case 'a': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#55FF55").getOrThrow());
                    break;
                }
                case 'b': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#55FFFF").getOrThrow());
                    break;
                }
                case 'c': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#FF5555").getOrThrow());
                    break;
                }
                case 'd': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#FF55FF").getOrThrow());
                    break;
                }
                case 'e': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#FFFF55").getOrThrow());
                    break;
                }
                case 'f': {
                    currentStyle = Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#FFFFFF").getOrThrow());
                    break;
                }
                case 'l': {
                    currentStyle = currentStyle.withBold(Boolean.valueOf(true));
                    break;
                }
                case 'm': {
                    currentStyle = currentStyle.withStrikethrough(Boolean.valueOf(true));
                    break;
                }
                case 'n': {
                    currentStyle = currentStyle.withUnderlined(Boolean.valueOf(true));
                    break;
                }
                case 'o': {
                    currentStyle = currentStyle.withItalic(Boolean.valueOf(true));
                    break;
                }
                case 'r': {
                    currentStyle = Style.EMPTY;
                    break;
                }
            }
            if (content.isEmpty()) continue;
            MutableComponent styledComponent = Component.literal((String)content).setStyle(currentStyle);
            rootComponent.append((Component)styledComponent);
        }
        return rootComponent;
    }
}

