/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips.foundation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.api.TextAnchor;
import toni.immersivetips.api.ModifyTip;

public class ImmersiveTip {
    public static final Codec<ImmersiveTip> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("title").forGetter(tip -> Optional.ofNullable(tip.title)), (App)Codec.STRING.optionalFieldOf("literal").forGetter(tip -> Optional.ofNullable(tip.literal)), (App)Codec.STRING.optionalFieldOf("condition").forGetter(tip -> Optional.ofNullable(tip.condition)), (App)ResourceLocation.CODEC.optionalFieldOf("translate").forGetter(tip -> Optional.ofNullable(tip.translate)), (App)Codec.FLOAT.optionalFieldOf("duration").forGetter(tip -> Optional.of(Float.valueOf(tip.duration))), (App)Codec.INT.optionalFieldOf("multiplier").forGetter(tip -> Optional.of(tip.multiplier)), (App)Priority.CODEC.optionalFieldOf("priority").forGetter(tip -> Optional.of(tip.priority))).apply((Applicative)instance, ImmersiveTip::new));
    private ImmersiveMessage cachedMessage;
    public String title;
    public String literal = "";
    public ResourceLocation translate;
    public Priority priority = Priority.LOW;
    public float duration = 15.0f;
    public int multiplier = -1;
    public String condition = "";

    public ImmersiveTip(String title, String literal) {
        this.title = title;
        this.literal = literal;
    }

    public ImmersiveTip(String title, ResourceLocation translate) {
        this.title = title;
        this.translate = translate;
    }

    public ImmersiveTip(String title, String literal, float duration) {
        this.title = title;
        this.literal = literal;
        this.duration = duration;
    }

    public ImmersiveTip(String title, ResourceLocation translate, float duration) {
        this.title = title;
        this.translate = translate;
        this.duration = duration;
    }

    public ImmersiveTip(Optional<String> title, Optional<String> literal, Optional<String> condition, Optional<ResourceLocation> translate, Optional<Float> duration, Optional<Integer> multiplier, Optional<Priority> priority) {
        this.title = title.orElse("Tip");
        this.literal = literal.orElse("");
        this.condition = condition.orElse("");
        this.translate = translate.orElse(null);
        this.duration = duration.orElse(Float.valueOf(15.0f)).floatValue();
        this.multiplier = multiplier.orElse(-1);
        this.priority = priority.orElse(Priority.MEDIUM);
    }

    public ImmersiveMessage getMessage() {
        if (this.cachedMessage != null) {
            return this.cachedMessage;
        }
        this.cachedMessage = ImmersiveMessage.builder((float)this.duration, (String)this.title).anchor(TextAnchor.BOTTOM_LEFT).wrap().y(0.0f).size(1.0f).slideLeft(0.3f).slideOutRight(0.3f).fadeIn(0.5f).fadeOut(0.5f).color(ChatFormatting.GOLD).style(style -> style.withUnderlined(Boolean.valueOf(true))).subtext(0.0f, this.getText(), 11.0f, subtext -> subtext.anchor(TextAnchor.BOTTOM_LEFT).wrap().size(1.0f).slideLeft(0.3f).slideOutRight(0.3f).fadeIn(0.5f).fadeOut(0.5f));
        ((ModifyTip)ModifyTip.EVENT.invoker()).onTipCreate(this.cachedMessage);
        return this.cachedMessage;
    }

    public int hashCode() {
        return ((this.translate != null ? this.translate.getPath() : "") + this.literal).hashCode();
    }

    private String getText() {
        return this.translate == null ? this.literal : Component.translatableWithFallback((String)this.translate.getPath(), (String)this.literal).getString();
    }

    public static enum Priority implements StringRepresentable
    {
        LOW("low"),
        MEDIUM("medium"),
        HIGH("high"),
        IMMEDIATE("immediate");

        public static final Codec<Priority> CODEC;
        public static final List<Priority> VALUES;
        private final String name;

        private Priority(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Priority::values);
            VALUES = Arrays.stream(Priority.values()).toList();
        }
    }
}

