/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivetips;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.immersivetips.ImmersiveTipsClient;
import toni.immersivetips.foundation.ImmersiveTip;
import toni.immersivetips.foundation.TipsPersistentData;
import toni.immersivetips.foundation.TipsResourceReloadListener;
import toni.immersivetips.foundation.config.AllConfigs;

@Mod(value="immersivetips")
public class ImmersiveTips {
    public static final String MODNAME = "Immersive Tips";
    public static final String ID = "immersivetips";
    public static final Logger LOGGER = LogManager.getLogger((String)"Immersive Tips");
    private static final Random random = new Random();
    public static TipsPersistentData persistentData;
    public static List<ImmersiveTip> LocalTips;
    public static List<ImmersiveTip> RemoteTips;
    public static Map<ImmersiveTip.Priority, List<ImmersiveTip>> EnabledTips;
    public static List<ImmersiveTip> DisabledTips;
    public static Map<ResourceLocation, List<Component>> ItemTooltips;

    public ImmersiveTips(IEventBus modEventBus, ModContainer modContainer) {
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)new TipsResourceReloadListener());
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> modContainer.registerConfig(type, (IConfigSpec)spec));
    }

    public static ImmersiveTip getNextTip() {
        List<ImmersiveTip> list = null;
        double weight = Math.random();
        List<ImmersiveTip> immediate = EnabledTips.get((Object)ImmersiveTip.Priority.IMMEDIATE);
        List<ImmersiveTip> high = EnabledTips.get((Object)ImmersiveTip.Priority.HIGH);
        List<ImmersiveTip> medium = EnabledTips.get((Object)ImmersiveTip.Priority.MEDIUM);
        List<ImmersiveTip> low = EnabledTips.get((Object)ImmersiveTip.Priority.LOW);
        int highSize = high != null && !high.isEmpty() ? high.size() : 0;
        int mediumSize = high != null && !high.isEmpty() ? high.size() : 0;
        float highWeight = 1.0f - Math.max(0.3f, Math.min(0.4f, (float)highSize * 0.02f));
        float mediumWeight = highWeight - Math.max(0.3f, Math.min(0.3f, (float)mediumSize * 0.02f));
        list = immediate != null && !immediate.isEmpty() ? immediate : (high != null && !high.isEmpty() && weight > (double)highWeight ? high : (medium != null && !medium.isEmpty() && weight > (double)mediumWeight ? medium : low));
        if (list == null || list.isEmpty()) {
            return null;
        }
        ImmersiveTip tip = list.get(random.nextInt(list.size()));
        if (tip.multiplier > -1) {
            --tip.multiplier;
            if (tip.multiplier <= 0) {
                list.remove(tip);
                DisabledTips.add(tip);
                ImmersiveTips.persistentData.seenTips.add(tip.hashCode());
                persistentData.save();
            }
        }
        return tip;
    }

    public void onInitialize() {
    }

    public void onInitializeClient() {
        persistentData = TipsPersistentData.load();
        ImmersiveTipsClient.init();
        ClientLifecycleEvents.CLIENT_STOPPING.register(mc -> persistentData.save());
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }

    public static boolean isDedicatedServer() {
        return FMLLoader.getDist() == Dist.DEDICATED_SERVER;
    }

    static {
        LocalTips = new ArrayList<ImmersiveTip>();
        RemoteTips = new ArrayList<ImmersiveTip>();
        EnabledTips = new HashMap<ImmersiveTip.Priority, List<ImmersiveTip>>();
        DisabledTips = new ArrayList<ImmersiveTip>();
        ItemTooltips = new HashMap<ResourceLocation, List<Component>>();
    }
}

