/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.util;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;
import vazkii.patchouli.common.item.ItemModBook;

public final class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static Triple<Holder<Item>, DataComponentPatch, Integer> deserializeStack(String string, HolderLookup.Provider registries) {
        StringReader reader = new StringReader(string.trim());
        ItemParser itemParser = new ItemParser(registries);
        try {
            ItemParser.ItemResult result = itemParser.parse(reader);
            int count = 1;
            if (reader.canRead()) {
                reader.expect('#');
                count = reader.readInt();
            }
            return Triple.of((Object)result.item(), (Object)result.components(), (Object)count);
        }
        catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static ItemStack loadFromParsed(Triple<Holder<Item>, DataComponentPatch, Integer> parsed) {
        Holder holder = (Holder)parsed.getLeft();
        DataComponentPatch components = (DataComponentPatch)parsed.getMiddle();
        Integer count = (Integer)parsed.getRight();
        if (!holder.isBound() && holder.unwrapKey().isPresent()) {
            throw new RuntimeException("Unknown item ID: " + String.valueOf(((ResourceKey)holder.unwrapKey().get()).location()));
        }
        Item item = (Item)holder.value();
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
        if (!components.isEmpty()) {
            stack.applyComponents(components);
        }
        return stack;
    }

    public static ItemStack loadStackFromString(String res, HolderLookup.Provider registries) {
        return ItemStackUtil.loadFromParsed(ItemStackUtil.deserializeStack(res, registries));
    }

    public static Ingredient loadIngredientFromString(String ingredientString, HolderLookup.Provider registries) {
        return Ingredient.of((ItemStack[])ItemStackUtil.loadStackListFromString(ingredientString, registries).toArray(new ItemStack[0]));
    }

    public static List<ItemStack> loadStackListFromString(String ingredientString, HolderLookup.Provider registries) {
        String[] stacksSerialized = ItemStackUtil.splitStacksFromSerializedIngredient(ingredientString);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String s : stacksSerialized) {
            if (s.isEmpty()) continue;
            if (s.startsWith("tag:")) {
                TagKey key = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)s.substring(4)));
                registries.lookupOrThrow(Registries.ITEM).get(key).stream().flatMap(HolderSet::stream).forEach(item -> stacks.add(new ItemStack(item)));
                continue;
            }
            stacks.add(ItemStackUtil.loadStackFromString(s, registries));
        }
        return stacks;
    }

    public static StackWrapper wrapStack(ItemStack stack) {
        return stack.isEmpty() ? StackWrapper.EMPTY_WRAPPER : new StackWrapper(stack);
    }

    @Nullable
    public static Book getBookFromStack(ItemStack stack) {
        if (stack.getItem() instanceof ItemModBook) {
            return ItemModBook.getBook(stack);
        }
        Collection<Book> books = BookRegistry.INSTANCE.books.values();
        for (Book b : books) {
            if (!ItemStack.isSameItem((ItemStack)b.getBookItem(), (ItemStack)stack)) continue;
            return b;
        }
        return null;
    }

    private static String[] splitStacksFromSerializedIngredient(String ingredientSerialized) {
        ArrayList<String> result = new ArrayList<String>();
        int lastIndex = 0;
        int braces = 0;
        int brackets = 0;
        Character insideString = null;
        block9: for (int i = 0; i < ingredientSerialized.length(); ++i) {
            switch (ingredientSerialized.charAt(i)) {
                case '{': {
                    if (insideString != null) continue block9;
                    ++braces;
                    continue block9;
                }
                case '}': {
                    if (insideString != null) continue block9;
                    --braces;
                    continue block9;
                }
                case '[': {
                    if (insideString != null) continue block9;
                    ++brackets;
                    continue block9;
                }
                case ']': {
                    if (insideString != null) continue block9;
                    --brackets;
                    continue block9;
                }
                case '\'': {
                    insideString = insideString == null ? Character.valueOf('\'') : null;
                    continue block9;
                }
                case '\"': {
                    insideString = insideString == null ? Character.valueOf('\"') : null;
                    continue block9;
                }
                case ',': {
                    if (braces > 0 || brackets > 0) continue block9;
                    result.add(ingredientSerialized.substring(lastIndex, i));
                    lastIndex = i + 1;
                }
            }
        }
        result.add(ingredientSerialized.substring(lastIndex));
        return result.toArray(new String[0]);
    }

    public static ItemStack loadStackFromJson(JsonObject json, HolderLookup.Provider registries) {
        String itemName = json.get("item").getAsString();
        Item item = (Item)BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)itemName)).orElseThrow(() -> new IllegalArgumentException("Unknown item '" + itemName + "'"));
        ItemStack stack = new ItemStack((ItemLike)item, GsonHelper.getAsInt((JsonObject)json, (String)"count", (int)1));
        if (json.has("components")) {
            DataComponentMap.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)json.get("components")).result().ifPresent(arg_0 -> ((ItemStack)stack).applyComponents(arg_0));
        }
        return stack;
    }

    public static class StackWrapper {
        public static final StackWrapper EMPTY_WRAPPER = new StackWrapper(ItemStack.EMPTY);
        public final ItemStack stack;

        public StackWrapper(ItemStack stack) {
            this.stack = stack;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof StackWrapper && ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)((StackWrapper)obj).stack);
        }

        public int hashCode() {
            return this.stack.getItem().hashCode();
        }

        public String toString() {
            return "Wrapper[" + this.stack.toString() + "]";
        }
    }
}

