/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.razordevs.deep_aether.world.structure.DAStructureTypes;
import io.github.razordevs.deep_aether.world.structure.HeightSpawningChecks;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasBinding;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class DAJigsawStructure
extends Structure {
    public static final MapCodec<DAJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DAJigsawStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.CODEC.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)-4096, (int)4096).fieldOf("discard_below_y").forGetter(structure -> structure.discardBelowY), (App)Codec.intRange((int)-4096, (int)4096).fieldOf("discard_above_y").forGetter(structure -> structure.discardAboveY), (App)Codec.list((Codec)PoolAliasBinding.CODEC).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliases), (App)DimensionPadding.CODEC.optionalFieldOf("dimension_padding", (Object)DimensionPadding.ZERO).forGetter(structure -> structure.dimensionPadding), (App)LiquidSettings.CODEC.optionalFieldOf("liquid_settings", (Object)JigsawStructure.DEFAULT_LIQUID_SETTINGS).forGetter(structure -> structure.liquidSettings)).apply((Applicative)instance, DAJigsawStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final int discardBelowY;
    private final int discardAboveY;
    private final List<PoolAliasBinding> poolAliases;
    private final DimensionPadding dimensionPadding;
    private final LiquidSettings liquidSettings;

    protected DAJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, int discardBelowY, int discardAboveY, List<PoolAliasBinding> poolAliases, DimensionPadding dimensionPadding, LiquidSettings liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.discardBelowY = discardBelowY;
        this.discardAboveY = discardAboveY;
        this.poolAliases = poolAliases;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!new HeightSpawningChecks().checkHeight(context, this.discardBelowY, this.discardAboveY)) {
            return Optional.empty();
        }
        int startY = this.startHeight.sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        ChunkPos chunkPos = context.chunkPos();
        BlockPos pos = new BlockPos(chunkPos.getMiddleBlockX(), startY, chunkPos.getMiddleBlockZ());
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)pos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (PoolAliasLookup)PoolAliasLookup.create(this.poolAliases, (BlockPos)pos, (long)context.seed()), (DimensionPadding)this.dimensionPadding, (LiquidSettings)this.liquidSettings);
    }

    public StructureType<?> type() {
        return (StructureType)DAStructureTypes.DA_JIGSAW.get();
    }
}

