/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.razordevs.deep_aether.world.feature.tree.foliage.DAFoliagePlacers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class YagrootFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<YagrootFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(p2 -> YagrootFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)p2).and((App)IntProvider.codec((int)0, (int)24).fieldOf("trunk_height").forGetter(foliagePlacer -> foliagePlacer.trunkHeight)).apply((Applicative)p2, YagrootFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public YagrootFoliagePlacer(IntProvider intProvider, IntProvider intProvider1, IntProvider intProvider2) {
        super(intProvider, intProvider1);
        this.trunkHeight = intProvider2;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)DAFoliagePlacers.YAGROOT_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration configuration, int i1, FoliagePlacer.FoliageAttachment foliageAttachment, int foliageMaxHeight, int i2, int i3) {
        this.placeTreeLeavesRows(random.nextInt(1, 3), level, foliageSetter, random, configuration, foliageAttachment);
    }

    private void placeTreeLeavesRows(int size, LevelSimulatedReader level, FoliagePlacer.FoliageSetter foliageSetter, RandomSource random, TreeConfiguration configuration, FoliagePlacer.FoliageAttachment foliageAttachment) {
        int size2 = size != 1 ? size - 1 : size;
        this.placeLeavesRow(level, foliageSetter, random, configuration, foliageAttachment.pos(), size2, 1, false);
        this.placeLeavesRow(level, foliageSetter, random, configuration, foliageAttachment.pos(), size, 0, false);
        this.placeLeavesRow(level, foliageSetter, random, configuration, foliageAttachment.pos(), size2, -1, false);
    }

    public int foliageHeight(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return Math.max(4, i - this.trunkHeight.sample(randomSource));
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int a, int b, int c, int d, boolean b1) {
        return a == d && c == d && d > 0;
    }

    protected void placeLeavesRow(LevelSimulatedReader simulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration configuration, BlockPos blockPos, int i1, int i2, boolean b) {
        int i = b ? 1 : 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j = -i1; j <= i1 + i; ++j) {
            for (int k = -i1; k <= i1 + i; ++k) {
                if (this.shouldSkipLocationSigned(randomSource, j, i2, k, i1, b)) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, j, i2, k);
                YagrootFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)simulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)configuration, (BlockPos)blockpos$mutableblockpos);
            }
        }
    }
}

