/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.tree.decorators;

import com.mojang.serialization.MapCodec;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.tree.decorators.DADecoratorType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class GlowingTrunkVineDecorator
extends TreeDecorator {
    public static final MapCodec<GlowingTrunkVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final GlowingTrunkVineDecorator INSTANCE = new GlowingTrunkVineDecorator();

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)DADecoratorType.GLOWING_TRUNK_VINE.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource randomsource = context.random();
        context.logs().forEach(pos -> {
            BlockPos blockpos3;
            BlockPos blockpos2;
            BlockPos blockpos1;
            BlockPos blockpos;
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos = pos.west())) {
                GlowingTrunkVineDecorator.placeVine(blockpos, VineBlock.EAST, context);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos1 = pos.east())) {
                GlowingTrunkVineDecorator.placeVine(blockpos1, VineBlock.WEST, context);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos2 = pos.north())) {
                GlowingTrunkVineDecorator.placeVine(blockpos2, VineBlock.SOUTH, context);
            }
            if (randomsource.nextInt(3) > 0 && context.isAir(blockpos3 = pos.south())) {
                GlowingTrunkVineDecorator.placeVine(blockpos3, VineBlock.NORTH, context);
            }
        });
    }

    private static Block getRandomVine(RandomSource random) {
        if (random.nextInt(5) == 1) {
            return (Block)DABlocks.GLOWING_VINE.get();
        }
        return Blocks.VINE;
    }

    private static void placeVine(BlockPos pPos, BooleanProperty pSideProperty, TreeDecorator.Context context) {
        context.setBlock(pPos, (BlockState)GlowingTrunkVineDecorator.getRandomVine(context.random()).defaultBlockState().setValue((Property)pSideProperty, (Comparable)Boolean.TRUE));
    }
}

