/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.aetherteam.aether.block.AetherBlocks;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.features.configuration.DAHugeMushroomFeatureConfiguration;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class DAHugeMushroomFeature
extends Feature<DAHugeMushroomFeatureConfiguration> {
    public DAHugeMushroomFeature(Codec<DAHugeMushroomFeatureConfiguration> configuration) {
        super(configuration);
    }

    public boolean place(FeaturePlaceContext<DAHugeMushroomFeatureConfiguration> pContext) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        RandomSource randomsource = pContext.random();
        DAHugeMushroomFeatureConfiguration config = (DAHugeMushroomFeatureConfiguration)pContext.config();
        int height = this.getTreeHeight(randomsource, config.baseHeight, config.randomHeight);
        if (!this.isValidPosition((LevelAccessor)worldgenlevel, blockpos, height, blockpos$mutableblockpos = new BlockPos.MutableBlockPos(), config)) {
            return false;
        }
        this.makeCap((LevelAccessor)worldgenlevel, randomsource, blockpos, height, blockpos$mutableblockpos, config);
        List<BlockPos> logs = this.placeTrunk((LevelAccessor)worldgenlevel, randomsource, blockpos, config, height, config.trunkRadius, blockpos$mutableblockpos);
        this.placeRoots(worldgenlevel, config.rootsProvider, randomsource, blockpos);
        this.alterGround(worldgenlevel, randomsource, logs);
        return true;
    }

    public void alterGround(WorldGenLevel level, RandomSource random, List<BlockPos> logs) {
        ArrayList list = Lists.newArrayList();
        list.addAll(logs);
        if (!list.isEmpty()) {
            int i = ((BlockPos)list.getFirst()).getY();
            list.stream().filter(pos -> pos.getY() == i).forEach(pos -> {
                this.placeCircle(level, pos.west().north());
                this.placeCircle(level, pos.east(2).north());
                this.placeCircle(level, pos.west().south(2));
                this.placeCircle(level, pos.east(2).south(2));
                for (int j = 0; j < 5; ++j) {
                    int k = random.nextInt(64);
                    int l = k % 8;
                    int i1 = k / 8;
                    if (l != 0 && l != 7 && i1 != 0 && i1 != 7) continue;
                    this.placeCircle(level, pos.offset(-3 + l, 0, -3 + i1));
                }
            });
        }
    }

    private void placeCircle(WorldGenLevel level, BlockPos pos) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.placeBlockAt(level, pos.offset(i, 0, j));
            }
        }
    }

    private void placeBlockAt(WorldGenLevel level, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.above(i);
            if (level.getBlockState(blockpos).is((Block)AetherBlocks.COLD_AERCLOUD.get()) && level.isEmptyBlock(blockpos.above())) {
                this.setBlock((LevelWriter)level, blockpos, ((Block)DABlocks.AERCLOUD_GRASS_BLOCK.get()).defaultBlockState());
                break;
            }
            if (!level.isEmptyBlock(blockpos) && i < 0) break;
        }
    }

    public void placeRoots(WorldGenLevel level, BlockStateProvider blockstate, RandomSource random, BlockPos pos) {
        for (int i = 1; i <= 4; ++i) {
            int intA = 0;
            int intB = 0;
            int intC = 0;
            int maxRootLength = random.nextInt(8, 15);
            int maxFlatRootLength = random.nextInt(4, 7);
            Direction direction = i == 1 ? Direction.NORTH : (i == 2 ? Direction.SOUTH : (i == 3 ? Direction.EAST : Direction.WEST));
            for (int j = 0; j < maxRootLength && intC < maxFlatRootLength; ++j) {
                if (level.isEmptyBlock(pos.below(intB + 1).relative(direction, intA))) {
                    ++intB;
                    intC = 0;
                } else if (level.isEmptyBlock(pos.below(intB).relative(direction, intA + 1))) {
                    ++intA;
                    ++intC;
                }
                this.setBlock((LevelWriter)level, pos.below(intB).relative(direction, intA), blockstate.getState(random, pos));
            }
        }
    }

    protected void makeCap(LevelAccessor level, RandomSource random, BlockPos pos, int height, BlockPos.MutableBlockPos mutablePos, DAHugeMushroomFeatureConfiguration config) {
        int a = config.trunkRadius % 2 == 0 ? -1 : 0;
        for (int y = height - 3; y <= height; ++y) {
            int j = y < height ? config.foliageRadius : config.foliageRadius - 1;
            int k = config.foliageRadius - 2 + a;
            int j2 = j - a;
            for (int x = -j; x <= j2; ++x) {
                for (int z = -j; z <= j2; ++z) {
                    boolean flag5;
                    boolean flag = x == -j;
                    boolean flag1 = x == j2;
                    boolean flag2 = z == -j;
                    boolean flag3 = z == j2;
                    boolean flag4 = flag || flag1;
                    boolean bl = flag5 = flag2 || flag3;
                    if (y < height && flag4 == flag5) continue;
                    mutablePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (level.getBlockState((BlockPos)mutablePos).isSolidRender((BlockGetter)level, (BlockPos)mutablePos)) continue;
                    BlockState blockstate = config.capProvider.getState(random, pos);
                    if (blockstate.hasProperty((Property)HugeMushroomBlock.WEST) && blockstate.hasProperty((Property)HugeMushroomBlock.EAST) && blockstate.hasProperty((Property)HugeMushroomBlock.NORTH) && blockstate.hasProperty((Property)HugeMushroomBlock.SOUTH) && blockstate.hasProperty((Property)HugeMushroomBlock.UP)) {
                        blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate.setValue((Property)HugeMushroomBlock.UP, (Comparable)Boolean.valueOf(y >= height - 1))).setValue((Property)HugeMushroomBlock.WEST, (Comparable)Boolean.valueOf(x < -k))).setValue((Property)HugeMushroomBlock.EAST, (Comparable)Boolean.valueOf(x > k))).setValue((Property)HugeMushroomBlock.NORTH, (Comparable)Boolean.valueOf(z < -k))).setValue((Property)HugeMushroomBlock.SOUTH, (Comparable)Boolean.valueOf(z > k));
                    }
                    this.setBlock((LevelWriter)level, (BlockPos)mutablePos, blockstate);
                }
            }
        }
    }

    protected int getTreeRadiusForHeight(int radius, int height) {
        int i = 0;
        if (height < -1 && height >= -4) {
            i = radius;
        } else if (height == -1) {
            i = radius;
        }
        return i;
    }

    protected List<BlockPos> placeTrunk(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, DAHugeMushroomFeatureConfiguration pConfig, int pMaxHeight, int radius, BlockPos.MutableBlockPos pMutablePos) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        for (int iii = 0; iii < radius; ++iii) {
            for (int ii = 0; ii < radius; ++ii) {
                for (int i = 0; i < pMaxHeight; ++i) {
                    pMutablePos.set((Vec3i)pPos).move(Direction.UP, i).move(Direction.NORTH, ii - radius / 2).move(Direction.EAST, iii);
                    if (pLevel.getBlockState((BlockPos)pMutablePos).isSolidRender((BlockGetter)pLevel, (BlockPos)pMutablePos)) continue;
                    this.setBlock((LevelWriter)pLevel, (BlockPos)pMutablePos, pConfig.stemProvider.getState(pRandom, pPos));
                    pos.add(pPos);
                }
            }
        }
        return pos;
    }

    protected boolean isValidPosition(LevelAccessor pLevel, BlockPos pPos, int pMaxHeight, BlockPos.MutableBlockPos pMutablePos, DAHugeMushroomFeatureConfiguration pConfig) {
        int i = pPos.getY();
        if (i >= pLevel.getMinBuildHeight() + 1 && i + pMaxHeight + 1 < pLevel.getMaxBuildHeight()) {
            BlockState blockstate = pLevel.getBlockState(pPos.below());
            if (!DAHugeMushroomFeature.isDirt((BlockState)blockstate) && !blockstate.is(BlockTags.MUSHROOM_GROW_BLOCK)) {
                return false;
            }
            for (int j = 0; j <= pMaxHeight; ++j) {
                int k = this.getTreeRadiusForHeight(pConfig.foliageRadius, j);
                for (int l = -k; l <= k; ++l) {
                    for (int i1 = -k; i1 <= k; ++i1) {
                        BlockState blockstate1 = pLevel.getBlockState((BlockPos)pMutablePos.setWithOffset((Vec3i)pPos, l, j, i1));
                        if (blockstate1.isAir() || blockstate1.is(BlockTags.LEAVES)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected int getTreeHeight(RandomSource pRandom, int baseHeight, int randomHeight) {
        return pRandom.nextInt(randomHeight) + baseHeight;
    }
}

