/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.datagen.tags.DATags;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.world.feature.features.configuration.AercloudCloudConfiguration;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;

public class AercloudCloudFeature
extends Feature<AercloudCloudConfiguration> {
    public static final PerlinSimplexNoise NOISE = new PerlinSimplexNoise((RandomSource)new XoroshiroRandomSource(42L), List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1)));
    public static final int lowestY = 155;

    public AercloudCloudFeature(Codec<AercloudCloudConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<AercloudCloudConfiguration> context) {
        WorldGenLevel reader = context.level();
        BlockPos pos = context.origin();
        AercloudCloudConfiguration config = (AercloudCloudConfiguration)context.config();
        this.place(reader, pos, config, context.random(), config.hasGrass());
        return true;
    }

    public void place(WorldGenLevel reader, BlockPos pos, AercloudCloudConfiguration config, RandomSource random, boolean hasGrass) {
        boolean goAgainstX = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, 16)).is(DATags.Biomes.IS_CLOUD);
        boolean goAgainstNegativeX = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, -16)).is(DATags.Biomes.IS_CLOUD);
        boolean goAgainstZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_CLOUD);
        boolean goAgainstNegativeZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_CLOUD);
        boolean goAgainstXAndZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, 16).relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_CLOUD) && !goAgainstX && !goAgainstZ;
        boolean goAgainstXAndNegativeZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, 16).relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_CLOUD) && !goAgainstX && !goAgainstNegativeZ;
        boolean goAgainstNegativeXAndZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, -16).relative(Direction.Axis.Z, 16)).is(DATags.Biomes.IS_CLOUD) && !goAgainstNegativeX && !goAgainstZ;
        boolean goAgainstNegativeXAndNegativeZ = !reader.getBiomeManager().getNoiseBiomeAtPosition(pos.relative(Direction.Axis.X, -16).relative(Direction.Axis.Z, -16)).is(DATags.Biomes.IS_CLOUD) && !goAgainstNegativeX && !goAgainstNegativeZ;
        int chunkX = pos.getX() - pos.getX() % 16;
        int chunkZ = pos.getZ() - pos.getZ() % 16;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double bottom;
                int xCoord = chunkX + x;
                int zCoord = chunkZ + z;
                double bottomNoiseValue = NOISE.getValue((double)xCoord * 0.02, (double)zCoord * 0.02, false);
                double originalBottom = bottom = Math.abs(Mth.lerp((double)bottomNoiseValue, (double)4.0, (double)2.0));
                double topNoiseValue = NOISE.getValue((double)xCoord * 0.007, (double)zCoord * 0.007, false);
                double top = Mth.lerp((double)topNoiseValue, (double)-2.0, (double)7.0) + 2.0;
                if (top < 3.0) {
                    top -= (3.0 - top) * 2.0;
                }
                double decreaseMultiplier = 1.5;
                double decreaseMultiplierCorner = 4.0;
                if (goAgainstX && x > 8) {
                    bottom += ((double)x - 8.0) / 1.5;
                    top -= ((double)x - 8.0) / 1.5;
                }
                if (goAgainstNegativeX && x <= 8) {
                    bottom += (8.0 - (double)x) / 1.5;
                    top -= (8.0 - (double)x) / 1.5;
                }
                if (goAgainstZ && z > 8) {
                    bottom += ((double)z - 8.0) / 1.5;
                    top -= ((double)z - 8.0) / 1.5;
                }
                if (goAgainstNegativeZ) {
                    if (z < 8) {
                        bottom += (8.0 - (double)z) / 1.5;
                        top -= (8.0 - (double)z) / 1.5;
                    }
                } else if (goAgainstXAndZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstXAndNegativeZ) {
                    if (x > 12) {
                        bottom += ((double)x - 12.0) / 4.0;
                        top -= ((double)x - 12.0) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                } else if (goAgainstNegativeXAndZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z > 12) {
                        bottom += ((double)z - 12.0) / 4.0;
                        top -= ((double)z - 12.0) / 4.0;
                    }
                } else if (goAgainstNegativeXAndNegativeZ) {
                    if (x < 4) {
                        bottom += (4.0 - (double)x) / 4.0;
                        top -= (4.0 - (double)x) / 4.0;
                    }
                    if (z < 4) {
                        bottom += (4.0 - (double)z) / 4.0;
                        top -= (4.0 - (double)z) / 4.0;
                    }
                }
                int y = Math.round(Math.round(155.0 + bottom - top / 2.0));
                while ((double)y < 155.0 + top + originalBottom) {
                    this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), config.block().getState(random, pos));
                    ++y;
                }
                if (hasGrass && top >= 4.0) {
                    this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y), ((Block)DABlocks.AERCLOUD_GRASS_BLOCK.get()).defaultBlockState());
                }
                originalBottom *= 4.0;
                int a = 0;
                if (originalBottom < 12.0) {
                    a = (int)(12.0 - originalBottom);
                }
                y = 12 + a;
                while ((double)y > originalBottom) {
                    this.setBlock((LevelWriter)reader, pos.relative(Direction.Axis.X, x).relative(Direction.Axis.Z, z).atY(y + 155 + 20), config.block().getState(random, pos));
                    --y;
                }
            }
        }
    }
}

