/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.gear;

import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.item.EquipmentUtil;
import io.github.razordevs.deep_aether.DeepAetherConfig;
import io.github.razordevs.deep_aether.item.gear.DAEquipmentUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="deep_aether")
public class DaAbilityListener {
    @SubscribeEvent
    public static void onEntityFall(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!event.isCanceled()) {
            event.setCanceled(DAEquipmentUtil.hasFullStratusSet(livingEntity));
        }
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (EquipmentUtil.hasFullGravititeSet((LivingEntity)livingEntity) && livingEntity instanceof Player && ((AetherPlayerAttachment)(player = (Player)livingEntity).getData((Supplier)AetherDataAttachments.AETHER_PLAYER)).isGravititeJumpActive()) {
            player.push(0.0, DAEquipmentUtil.handleStratusRingBoost(livingEntity) - 1.0, 0.0);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
            }
        }
    }

    @SubscribeEvent
    public static void onMiningSpeed(PlayerEvent.BreakSpeed event) {
        if (((Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get()).booleanValue()) {
            return;
        }
        Player player = event.getEntity();
        if (!event.isCanceled()) {
            event.setNewSpeed(DAEquipmentUtil.handleSkyjadeRingAbility((LivingEntity)player, event.getNewSpeed()));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get()).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        BlockPos pos = event.getPos();
        if (!event.isCanceled()) {
            DAEquipmentUtil.damageSkyjadeRing((LivingEntity)player, level, state, pos);
        }
    }
}

