/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.github.razordevs.deep_aether.client.model.AerglowFishModel;
import io.github.razordevs.deep_aether.client.renderer.DAModelLayers;
import io.github.razordevs.deep_aether.entity.living.AerglowFish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class AetherFishRenderer
extends MobRenderer<AerglowFish, AerglowFishModel> {
    private static final ResourceLocation AERGLOW_FISH_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/entity/aerglow_fish.png");

    public AetherFishRenderer(EntityRendererProvider.Context renderer) {
        super(renderer, (EntityModel)new AerglowFishModel(renderer.bakeLayer(DAModelLayers.AERGLOW_FISH)), 0.4f);
    }

    public ResourceLocation getTextureLocation(AerglowFish fish) {
        return AERGLOW_FISH_LOCATION;
    }

    protected void setupRotations(AerglowFish fish, PoseStack pose, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations((LivingEntity)fish, pose, ageInTicks, rotationYaw, partialTicks, scale);
        float f = 1.0f;
        float f1 = 1.0f;
        if (!fish.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        float f2 = f * 4.3f * Mth.sin((float)(f1 * 0.6f * ageInTicks));
        pose.mulPose(Axis.YP.rotationDegrees(f2));
        pose.translate(0.0f, 0.0f, -0.4f);
        if (!fish.isInWater()) {
            pose.translate(0.2f, 0.1f, 0.0f);
            pose.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
    }
}

