/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.boss.eots.EOTSSegment;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EOTSSegmentModel
extends HierarchicalModel<EOTSSegment> {
    private final ModelPart body;
    private final ModelPart bb_main;
    private final ModelPart bb_segment;
    private final ModelPart upperMouth;
    private final ModelPart lowerMouth;

    public EOTSSegmentModel(ModelPart root) {
        this.body = root.getChild("body");
        this.bb_main = root.getChild("bb_main");
        this.bb_segment = root.getChild("bb_segment");
        this.upperMouth = this.bb_main.getChild("Head").getChild("upperMouth");
        this.lowerMouth = this.bb_main.getChild("Head").getChild("lowerMouth");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -8.0f, 0.0f, 14.0f, 12.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)18.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("bb_segment", CubeListBuilder.create().texOffs(28, 28).addBox(-9.0f, -13.0f, -6.0f, 2.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(7.0f, -13.0f, -6.0f, 2.0f, 10.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition bb_main = partdefinition.addOrReplaceChild("bb_main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)-3.0f));
        bb_main.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(44, 13).addBox(-4.0f, -5.0f, 0.0f, 8.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)1.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Head11 = bb_main.addOrReplaceChild("Head11", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-6.0f, (float)8.0f));
        Head11.addOrReplaceChild("Head_r1", CubeListBuilder.create().texOffs(16, 28).addBox(-3.5f, -1.0f, -4.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-6.0f, (float)1.0f, (float)1.0462f, (float)0.5295f, (float)0.2342f));
        PartDefinition Head10 = bb_main.addOrReplaceChild("Head10", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)-6.0f, (float)8.0f));
        Head10.addOrReplaceChild("Head_r2", CubeListBuilder.create().texOffs(0, 21).addBox(1.5f, -6.0f, -4.0f, 2.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)-2.0f, (float)0.2618f, (float)-0.3054f, (float)0.0f));
        PartDefinition Head2 = bb_main.addOrReplaceChild("Head2", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)-6.0f, (float)8.0f));
        Head2.addOrReplaceChild("Head_r3", CubeListBuilder.create().texOffs(0, 40).addBox(-3.5f, -1.0f, -4.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)3.0f, (float)0.5662f, (float)0.5295f, (float)0.2342f));
        Head2.addOrReplaceChild("Head_r4", CubeListBuilder.create().texOffs(28, 9).addBox(-3.5f, -6.0f, -4.0f, 2.0f, 7.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)-2.0f, (float)0.2618f, (float)0.3054f, (float)0.0f));
        PartDefinition Head = bb_main.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -10.0f, 8.0f, 9.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-6.0f, (float)8.0f));
        Head.addOrReplaceChild("Head_r5", CubeListBuilder.create().texOffs(32, 30).addBox(1.5f, -1.0f, -4.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)3.0f, (float)0.5662f, (float)-0.5295f, (float)-0.2342f));
        Head.addOrReplaceChild("Head_r6", CubeListBuilder.create().texOffs(16, 42).addBox(1.5f, -1.0f, -4.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-6.0f, (float)1.0f, (float)1.0462f, (float)-0.5295f, (float)-0.2342f));
        Head.addOrReplaceChild("upperMouth", CubeListBuilder.create().texOffs(44, 0).addBox(-2.5f, -3.0f, -8.0f, 5.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)3.0f, (float)-10.0f));
        Head.addOrReplaceChild("lowerMouth", CubeListBuilder.create().texOffs(70, 3).addBox(-2.5f, 0.0f, -8.0f, 5.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)3.0f, (float)-10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(EOTSSegment entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (entity.isControllingSegment()) {
            this.body.visible = false;
            this.bb_segment.visible = false;
            this.bb_main.visible = true;
            if (entity.isMouthOpen()) {
                if (this.upperMouth.xRot > -0.3f) {
                    float mouthRotation;
                    this.upperMouth.xRot = mouthRotation = Mth.lerp((float)(ageInTicks * 0.01f), (float)this.upperMouth.xRot, (float)-0.3f);
                    this.lowerMouth.xRot = -mouthRotation;
                }
            } else if (this.upperMouth.xRot < 0.0f) {
                float mouthRotation;
                this.upperMouth.xRot = mouthRotation = Mth.lerp((float)(ageInTicks * 0.01f), (float)this.upperMouth.xRot, (float)0.0f);
                this.lowerMouth.xRot = -mouthRotation;
            }
        } else {
            this.body.visible = true;
            this.bb_segment.visible = true;
            this.bb_main.visible = false;
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bb_main.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.bb_segment.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.body;
    }
}

