/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.BabyZephyr;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BabyZephyrModel
extends EntityModel<BabyZephyr> {
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart tail2;

    public BabyZephyrModel(ModelPart root) {
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.tail2 = this.tail.getChild("tail2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -4.5f, -8.0f, 12.0f, 9.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)17.5f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        body.addOrReplaceChild("bb_main", CubeListBuilder.create().texOffs(30, 42).addBox(-8.0f, -10.0f, -5.0f, 2.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(2, 40).addBox(6.0f, -10.0f, -5.0f, 2.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(16, 38).addBox(-3.0f, -9.0f, -10.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)-11.0f));
        tail.addOrReplaceChild("tail1", CubeListBuilder.create().texOffs(40, 0).addBox(-3.0f, -9.0f, -17.0f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.5f, (float)11.0f));
        tail.addOrReplaceChild("tail2", CubeListBuilder.create().texOffs(59, 6).addBox(-4.0f, -8.0f, -2.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)6.5f, (float)-10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(BabyZephyr zephyr, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.tail.yRot = Mth.sin((float)(ageInTicks / 2.5f)) / 4.0f;
        this.tail2.yRot = Mth.sin((float)(ageInTicks / 2.5f)) / 4.0f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        poseStack.scale(0.3f, 0.3f, 0.3f);
        poseStack.translate(0.0f, 1.667f, 0.0f);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

