/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack.loader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrcrayfish.backpacked.Constants;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.platform.Services;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class BackpackLoader
extends SimpleJsonResourceReloadListener {
    private static final String DIRECTORY = "backpacked";
    private static final Gson GSON = new GsonBuilder().create();
    private final HolderLookup.Provider provider;

    public BackpackLoader(HolderLookup.Provider provider) {
        super(GSON, DIRECTORY);
        this.provider = provider;
    }

    protected HolderLookup.Provider getProvider() {
        return this.provider;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller filler) {
        HashMap<ResourceLocation, Backpack> backpacks = new HashMap<ResourceLocation, Backpack>();
        map.forEach((location, element) -> {
            String modId;
            if (location.getPath().contains("/")) {
                Constants.LOG.warn("Ignoring backpack '{}' as it was in a sub-directory", location);
                return;
            }
            JsonObject object = element.getAsJsonObject();
            if (object.has("mod_loaded") && object.get("mod_loaded").isJsonPrimitive() && !Services.REGISTRATION.isModLoaded(modId = object.get("mod_loaded").getAsString())) {
                return;
            }
            RegistryOps ops = this.getProvider().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            Backpack backpack = (Backpack)Backpack.CODEC.parse((DynamicOps)ops, (Object)object).getOrThrow(s -> {
                Constants.LOG.error("An error occurred when parsing the backpack '{}'", location);
                return new JsonParseException(s);
            });
            backpack.setup((ResourceLocation)location);
            backpacks.put((ResourceLocation)location, backpack);
        });
        BackpackManager.instance().updateBackpacks(backpacks);
    }
}

