/*
 * Decompiled with CFR 0.152.
 */
package net.tazgirl.dolphinfix;

import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

@Mod(value="dolphin_fix")
public class DolphinFix {
    public static final String MODID = "dolphin_fix";

    public DolphinFix(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingHurt(LivingIncomingDamageEvent event) {
        if (event.getEntity() instanceof Dolphin && event.getSource().is(DamageTypes.DROWN) && !DolphinFix.isPlayerNearby(event.getEntity().level(), (Entity)event.getEntity()) && event instanceof ICancellableEvent) {
            LivingIncomingDamageEvent cancellableEvent = event;
            cancellableEvent.setCanceled(true);
        }
    }

    public static boolean isPlayerNearby(Level level, Entity entity) {
        MinecraftServer server = level.getServer();
        if (server.getPlayerCount() == 0) {
            return false;
        }
        int simulationDistance = server.getPlayerList().getSimulationDistance() - 16;
        double distanceSqr = simulationDistance * simulationDistance * 16;
        for (Player player : level.players()) {
            if (!(player.distanceToSqr(entity) <= distanceSqr)) continue;
            return true;
        }
        return false;
    }
}

