/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.util.AccessoryUtil;
import me.pajic.accessorify.util.ClientUtil;
import me.pajic.accessorify.util.GameplayUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean isCreative();

    @Shadow
    public abstract boolean isSpectator();

    @Shadow
    public abstract void setReducedDebugInfo(boolean var1);

    @Shadow
    @NotNull
    public abstract ItemStack getItemBySlot(@NotNull EquipmentSlot var1);

    @Shadow
    public abstract void stopFallFlying();

    @ModifyExpressionValue(method={"tryToStartFallFlying"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemBySlot(Lnet/minecraft/world/entity/EquipmentSlot;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack tryGetElytraAccessory(ItemStack original) {
        if (((Boolean)Accessorify.CONFIG.accessorySettings.elytraAccessory.get()).booleanValue()) {
            ItemStack stack = AccessoryUtil.getAccessoryStack((LivingEntity)this, GameplayUtil::isElytra);
            return stack.isEmpty() ? original : stack;
        }
        return original;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void cancelElytraFlyingInLiquid(CallbackInfo ci) {
        if (((Boolean)Accessorify.CONFIG.cancelElytraFlyingInLiquid.get()).booleanValue() && (this.isInWater() || this.isInLava()) && this.isFallFlying() && (this.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ElytraItem || !AccessoryUtil.getAccessoryStack((LivingEntity)this, GameplayUtil::isElytra).isEmpty())) {
            this.stopFallFlying();
            this.setSwimming(true);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void setReducedDebugInfo(CallbackInfo ci) {
        if (((Boolean)Accessorify.CONFIG.hideDebugInfoInSurvival.get()).booleanValue()) {
            this.setReducedDebugInfo(!this.isCreative() && !this.isSpectator());
        }
    }

    @WrapMethod(method={"isScoping"})
    private boolean modifyScopingCondition(Operation<Boolean> original) {
        if (ClientUtil.shouldScope) {
            return true;
        }
        return (Boolean)original.call(new Object[0]);
    }
}

