/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.accessorify.accessories;

import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import me.pajic.accessorify.Accessorify;
import me.pajic.accessorify.accessories.AccessoryExtension;
import me.pajic.accessorify.util.AccessoryUtil;
import me.pajic.accessorify.util.CompatFlags;
import me.pajic.accessorify.util.compat.AileronCompat;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class ElytraAccessory
implements AccessoryExtension {
    @Override
    public String getAttributePath() {
        return "add_cape";
    }

    @Override
    public String getDefaultSlot() {
        return "cape";
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        if (CompatFlags.AILERON_LOADED) {
            AileronCompat.addModifiers(builder, stack, (HolderLookup.RegistryLookup<Enchantment>)reference.entity().level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT));
        }
    }

    public boolean canEquip(ItemStack stack, SlotReference reference) {
        return !AccessoryUtil.isAnotherEquipped(stack, reference, itemStack -> itemStack.getItem() instanceof ElytraItem);
    }

    public boolean canEquipFromUse(ItemStack stack, SlotReference reference) {
        return (Boolean)Accessorify.CONFIG.preventElytraRightClickEquip.get() == false && AccessoryExtension.super.canEquipFromUse(stack, reference);
    }
}

