/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask.mixin;

import dev.muon.questkilltask.DamageTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onDamage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        TamableAnimal tameable;
        LivingEntity victim = (LivingEntity)this;
        if (victim.level().isClientSide()) {
            return;
        }
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            DamageTracker.trackDamage(victim, player.getUUID());
            return;
        }
        Entity entity2 = source.getEntity();
        if (entity2 instanceof TamableAnimal && (entity2 = (tameable = (TamableAnimal)entity2).getOwner()) instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity2;
            DamageTracker.trackDamage(victim, owner.getUUID());
            return;
        }
        if (victim instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)victim;
            entity2 = source.getEntity();
            if (entity2 instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                DamageTracker.trackDamageTaken(attacker, player.getUUID());
                return;
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/LivingEntity;addEffect(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="HEAD")})
    private void onEffectAdded(MobEffectInstance effectInstance, Entity source, CallbackInfoReturnable<Boolean> cir) {
        if (!(source instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer supporter = (ServerPlayer)source;
        LivingEntity target = (LivingEntity)this;
        if (target.level().isClientSide()) {
            return;
        }
        MobEffect effect = (MobEffect)effectInstance.getEffect().value();
        boolean isEffectivelyBeneficial = this.isEffectBeneficialForTarget(effect, target);
        if (isEffectivelyBeneficial) {
            DamageTracker.trackHealing(target, supporter.getUUID());
        } else {
            DamageTracker.trackDamage(target, supporter.getUUID());
        }
    }

    @Unique
    private boolean isEffectBeneficialForTarget(MobEffect effect, LivingEntity target) {
        boolean isBeneficial = effect.isBeneficial();
        if (effect == MobEffects.HEAL || effect == MobEffects.HARM) {
            isBeneficial = isBeneficial != target.isInvertedHealAndHarm();
        }
        return isBeneficial;
    }
}

