/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import corgitaco.corgilib.network.UpdateStructureBoxPacketC2S;
import corgitaco.corgilib.platform.PlatformNetwork;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StructureBoxEditor {
    public static AABB structureBox = null;
    public static BlockPos structureBlockPos;
    public static BlockPos structureOffset;

    public static void render(PoseStack stack, VertexConsumer consumer, double camX, double camY, double camZ, boolean b) {
        if (structureBox != null && structureBlockPos != null && structureOffset != null) {
            AABB aabb = structureBox.move(structureOffset).move(structureBlockPos);
            LevelRenderer.renderVoxelShape((PoseStack)stack, (VertexConsumer)consumer, (VoxelShape)Shapes.create((AABB)aabb), (double)(-camX), (double)(-camY - 1.0), (double)(-camZ), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (boolean)b);
        }
    }

    public static boolean onScroll(double scrollValue) {
        LocalPlayer player;
        if (structureBox != null && structureBlockPos != null && structureOffset != null && (player = Minecraft.getInstance().player) != null && player.getItemInHand(InteractionHand.MAIN_HAND).is(Items.GOLDEN_AXE)) {
            if (!Minecraft.getInstance().level.getBlockState(structureBlockPos).is(Blocks.STRUCTURE_BLOCK)) {
                player.displayClientMessage((Component)Component.literal((String)"No longer editing structure block."), true);
                structureBox = null;
                structureBlockPos = null;
                structureOffset = null;
                return false;
            }
            Vec3 eyePosition = player.getEyePosition().add(0.0, 1.0, 0.0);
            Vec3 viewVector = player.getViewVector(0.0f);
            int distance = 250;
            Vec3 add = eyePosition.add(viewVector.x * (double)distance, viewVector.y * (double)distance, viewVector.z * (double)distance);
            BlockHitResult clip = AABB.clip(Collections.singleton(structureBox.move(structureOffset).move(structureBlockPos)), (Vec3)eyePosition, (Vec3)add, (BlockPos)BlockPos.ZERO);
            if (clip != null && clip.getType() != HitResult.Type.MISS) {
                Direction opposite = clip.getDirection().getOpposite();
                double xStep = (double)opposite.getStepX() * scrollValue;
                double yStep = (double)opposite.getStepY() * scrollValue;
                double zStep = (double)opposite.getStepZ() * scrollValue;
                if (StructureBoxEditor.isKeyDown(Minecraft.getInstance(), 340)) {
                    structureBox = new AABB(StructureBoxEditor.structureBox.minX, StructureBoxEditor.structureBox.minY, StructureBoxEditor.structureBox.minZ, Math.max(StructureBoxEditor.structureBox.minX + 1.0, StructureBoxEditor.structureBox.maxX + xStep), Math.max(StructureBoxEditor.structureBox.minY + 1.0, StructureBoxEditor.structureBox.maxY + yStep), Math.max(StructureBoxEditor.structureBox.minZ + 1.0, StructureBoxEditor.structureBox.maxZ + zStep));
                    PlatformNetwork.NETWORK.sendToServer(new UpdateStructureBoxPacketC2S(structureBlockPos, structureOffset, new BoundingBox((int)StructureBoxEditor.structureBox.minX, (int)StructureBoxEditor.structureBox.minY, (int)StructureBoxEditor.structureBox.minZ, (int)StructureBoxEditor.structureBox.maxX, (int)StructureBoxEditor.structureBox.maxY, (int)StructureBoxEditor.structureBox.maxZ)));
                    return true;
                }
                if (StructureBoxEditor.isKeyDown(Minecraft.getInstance(), 341)) {
                    structureOffset = structureOffset.offset((int)xStep, (int)yStep, (int)zStep);
                    PlatformNetwork.NETWORK.sendToServer(new UpdateStructureBoxPacketC2S(structureBlockPos, structureOffset, new BoundingBox((int)StructureBoxEditor.structureBox.minX, (int)StructureBoxEditor.structureBox.minY, (int)StructureBoxEditor.structureBox.minZ, (int)StructureBoxEditor.structureBox.maxX, (int)StructureBoxEditor.structureBox.maxY, (int)StructureBoxEditor.structureBox.maxZ)));
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static AABB getStructureWorldBox(StructureBlockEntity pBlockEntity) {
        BlockPos structurePos = pBlockEntity.getStructurePos();
        Vec3i structureSize = pBlockEntity.getStructureSize();
        if (structureSize.getX() >= 1 && structureSize.getY() >= 1 && structureSize.getZ() >= 1 && pBlockEntity.getMode() == StructureMode.SAVE) {
            double maxX;
            double minZ;
            double minX;
            double structureSizeX;
            double structurePosX = structurePos.getX();
            double structurePosZ = structurePos.getZ();
            double minY = structurePos.getY();
            double maxY = minY + (double)structureSize.getY();
            double structureSizeZ = switch (pBlockEntity.getMirror()) {
                case Mirror.LEFT_RIGHT -> {
                    structureSizeX = structureSize.getX();
                    yield -structureSize.getZ();
                }
                case Mirror.FRONT_BACK -> {
                    structureSizeX = -structureSize.getX();
                    yield structureSize.getZ();
                }
                default -> {
                    structureSizeX = structureSize.getX();
                    yield structureSize.getZ();
                }
            };
            double maxZ = switch (pBlockEntity.getRotation()) {
                case Rotation.CLOCKWISE_90 -> {
                    minX = structureSizeZ < 0.0 ? structurePosX : structurePosX + 1.0;
                    minZ = structureSizeX < 0.0 ? structurePosZ + 1.0 : structurePosZ;
                    maxX = minX - structureSizeZ;
                    yield minZ + structureSizeX;
                }
                case Rotation.CLOCKWISE_180 -> {
                    minX = structureSizeX < 0.0 ? structurePosX : structurePosX + 1.0;
                    minZ = structureSizeZ < 0.0 ? structurePosZ : structurePosZ + 1.0;
                    maxX = minX - structureSizeX;
                    yield minZ - structureSizeZ;
                }
                case Rotation.COUNTERCLOCKWISE_90 -> {
                    minX = structureSizeZ < 0.0 ? structurePosX + 1.0 : structurePosX;
                    minZ = structureSizeX < 0.0 ? structurePosZ : structurePosZ + 1.0;
                    maxX = minX + structureSizeZ;
                    yield minZ - structureSizeX;
                }
                default -> {
                    minX = structureSizeX < 0.0 ? structurePosX + 1.0 : structurePosX;
                    minZ = structureSizeZ < 0.0 ? structurePosZ + 1.0 : structurePosZ;
                    maxX = minX + structureSizeX;
                    yield minZ + structureSizeZ;
                }
            };
            if (pBlockEntity.getMode() == StructureMode.SAVE || pBlockEntity.getShowBoundingBox()) {
                return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
            }
        }
        return null;
    }

    public static boolean isKeyDown(Minecraft minecraft, int keyValue) {
        long window = minecraft.getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)keyValue);
    }
}

