/*
 * Decompiled with CFR 0.152.
 */
package me.khajiitos.worldplaytime.common.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import me.khajiitos.worldplaytime.common.util.Color;

public class WPTConfigValues {

    public static class ColorValue
    extends Value<Color> {
        public ColorValue(Color defaultValue) {
            super(defaultValue);
        }

        @Override
        public Color read(JsonElement jsonElement) {
            Color color = Color.fromString(jsonElement.getAsString());
            return color != null ? color : (Color)this.getDefault();
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive(((Color)this.get()).toString());
        }
    }

    public static class EnumValue<T extends Enum<?>>
    extends Value<T> {
        public EnumValue(T defaultValue) {
            super(defaultValue);
        }

        @Override
        public T read(JsonElement jsonElement) {
            String name = jsonElement.getAsString();
            for (Enum enumConstant : (Enum[])((Enum)this.getDefault()).getClass().getEnumConstants()) {
                if (!enumConstant.name().equalsIgnoreCase(name)) continue;
                return (T)enumConstant;
            }
            return (T)((Enum)this.getDefault());
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive(((Enum)this.get()).name().toLowerCase());
        }
    }

    public static class BooleanValue
    extends Value<Boolean> {
        public BooleanValue(Boolean defaultValue) {
            super(defaultValue);
        }

        @Override
        public Boolean read(JsonElement jsonElement) {
            return jsonElement.isJsonPrimitive() ? jsonElement.getAsJsonPrimitive().getAsBoolean() : ((Boolean)this.getDefault()).booleanValue();
        }

        @Override
        public JsonElement write() {
            return new JsonPrimitive((Boolean)this.get());
        }
    }

    public static abstract class Value<T> {
        private T value;
        private final T defaultValue;

        private Value(T defaultValue) {
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        public T get() {
            return this.value;
        }

        public void set(T value) {
            this.value = value;
        }

        public void setUnchecked(Object obj) {
            this.value = obj;
        }

        public T getDefault() {
            return this.defaultValue;
        }

        public abstract T read(JsonElement var1);

        public abstract JsonElement write();
    }
}

