/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.pack;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import schm.shsupercm.citresewn.CITResewn;
import schm.shsupercm.citresewn.cit.CIT;
import schm.shsupercm.citresewn.cit.CITCondition;
import schm.shsupercm.citresewn.cit.CITParsingException;
import schm.shsupercm.citresewn.cit.CITRegistry;
import schm.shsupercm.citresewn.cit.CITType;
import schm.shsupercm.citresewn.cit.builtin.conditions.core.FallbackCondition;
import schm.shsupercm.citresewn.cit.builtin.conditions.core.WeightCondition;
import schm.shsupercm.citresewn.pack.GlobalProperties;
import schm.shsupercm.citresewn.pack.format.PropertyGroup;
import schm.shsupercm.citresewn.pack.format.PropertyKey;
import schm.shsupercm.citresewn.pack.format.PropertyValue;

public final class PackParser {
    public static final List<String> ROOTS = List.of("mcpatcher", "optifine", "citresewn");

    private PackParser() {
    }

    public static GlobalProperties loadGlobalProperties(ResourceManager resourceManager, GlobalProperties globalProperties) {
        for (PackResources pack : resourceManager.listPacks().toList()) {
            for (String namespace : pack.getNamespaces(PackType.CLIENT_RESOURCES)) {
                for (String root : ROOTS) {
                    ResourceLocation identifier = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(root + "/cit.properties"));
                    try {
                        IoSupplier citPropertiesSupplier = pack.getResource(PackType.CLIENT_RESOURCES, identifier);
                        if (citPropertiesSupplier == null) continue;
                        globalProperties.load(pack.packId(), identifier, (InputStream)citPropertiesSupplier.get());
                    }
                    catch (FileNotFoundException citPropertiesSupplier) {
                    }
                    catch (Exception e) {
                        CITResewn.logErrorLoading("Errored while loading global properties: " + String.valueOf(identifier) + " from " + pack.packId());
                        e.printStackTrace();
                    }
                }
            }
        }
        return globalProperties;
    }

    public static List<CIT<?>> parseCITs(ResourceManager resourceManager) {
        ArrayList cits = new ArrayList();
        for (String root : ROOTS) {
            for (Map.Entry entry : resourceManager.listResources(root + "/cit", s -> s.getPath().endsWith(".properties")).entrySet()) {
                String packName = null;
                try {
                    packName = ((Resource)entry.getValue()).source().packId();
                    cits.add(PackParser.parseCIT(PropertyGroup.tryParseGroup(packName, (ResourceLocation)entry.getKey(), ((Resource)entry.getValue()).open()), resourceManager));
                }
                catch (CITParsingException e) {
                    CITResewn.logErrorLoading(e.getMessage());
                }
                catch (Exception e) {
                    CITResewn.logErrorLoading("Errored while loading cit: " + String.valueOf(entry.getKey()) + (String)(packName == null ? "" : " from " + packName));
                    e.printStackTrace();
                }
            }
        }
        return cits;
    }

    public static CIT<?> parseCIT(PropertyGroup properties, ResourceManager resourceManager) throws CITParsingException {
        CITType citType = CITRegistry.parseType(properties);
        ArrayList<CITCondition> conditions = new ArrayList<CITCondition>();
        Set<PropertyKey> ignoredProperties = citType.typeProperties();
        for (Map.Entry<PropertyKey, Set<PropertyValue>> entry : properties.properties.entrySet()) {
            if (entry.getKey().path().equals("type") && entry.getKey().namespace().equals("citresewn") || ignoredProperties.contains(entry.getKey())) continue;
            for (PropertyValue propertyValue : entry.getValue()) {
                conditions.add(CITRegistry.parseCondition(entry.getKey(), propertyValue, properties));
            }
        }
        for (CITCondition condition2 : new ArrayList(conditions)) {
            if (condition2 == null) continue;
            for (Class clazz : condition2.siblingConditions()) {
                conditions.replaceAll(siblingCondition -> siblingCondition != null && siblingConditionType == siblingCondition.getClass() ? condition2.modifySibling(siblingCondition) : siblingCondition);
            }
        }
        WeightCondition weight = new WeightCondition();
        FallbackCondition fallback = new FallbackCondition();
        conditions.removeIf(condition -> {
            if (condition instanceof WeightCondition) {
                WeightCondition weightCondition = (WeightCondition)condition;
                weight.setWeight(weightCondition.getWeight());
                return true;
            }
            if (condition instanceof FallbackCondition) {
                FallbackCondition fallbackCondition = (FallbackCondition)condition;
                fallback.setFallback(fallbackCondition.getFallback());
                return true;
            }
            return condition == null;
        });
        citType.load(conditions, properties, resourceManager);
        return new CIT<CITType>(properties.identifier, properties.packName, citType, conditions.toArray(new CITCondition[0]), weight.getWeight(), fallback.getFallback());
    }
}

