/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.mixin.common;

import com.mojang.datafixers.util.Either;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.IOUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import schm.shsupercm.citresewn.cit.CITType;
import schm.shsupercm.citresewn.defaults.common.ResewnItemModelIdentifier;
import schm.shsupercm.citresewn.mixin.types.item.JsonUnbakedModelAccessor;

@Mixin(value={ModelBakery.class})
public class ModelLoaderMixin {
    @Inject(method={"loadBlockModel"}, cancellable=true, at={@At(value="HEAD")})
    public void citresewn$forceLiteralResewnModelIdentifier(ResourceLocation originalId, CallbackInfoReturnable<BlockModel> cir) {
        if (ResewnItemModelIdentifier.marked(originalId)) {
            ResourceLocation id = ResewnItemModelIdentifier.unpack(originalId);
            try (InputStream is = ((Resource)Minecraft.getInstance().getResourceManager().getResource(id).orElseThrow()).open();){
                BlockModel json = BlockModel.fromString((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
                json.name = id.toString();
                json.name = json.name.substring(0, json.name.length() - 5);
                ((JsonUnbakedModelAccessor)json).getTextureMap().replaceAll((layer, original) -> {
                    Optional left = original.left();
                    if (left.isPresent()) {
                        ResourceLocation resolvedIdentifier;
                        String originalPath = ((Material)left.get()).texture().getPath();
                        String[] split = originalPath.split("/");
                        if ((originalPath.startsWith("./") || split.length > 2 && split[1].equals("cit")) && (resolvedIdentifier = CITType.resolveAsset(id, originalPath, "textures", ".png", Minecraft.getInstance().getResourceManager())) != null) {
                            return Either.left((Object)new Material(((Material)left.get()).atlasLocation(), resolvedIdentifier));
                        }
                    }
                    return original;
                });
                ResourceLocation parentId = ((JsonUnbakedModelAccessor)json).getParentLocation();
                if (parentId != null) {
                    String[] parentIdPathSplit = parentId.getPath().split("/");
                    if ((parentId.getPath().startsWith("./") || parentIdPathSplit.length > 2 && parentIdPathSplit[1].equals("cit")) && (parentId = CITType.resolveAsset(id, parentId.getPath(), "models", ".json", Minecraft.getInstance().getResourceManager())) != null) {
                        ((JsonUnbakedModelAccessor)json).setParentLocation(ResewnItemModelIdentifier.pack(parentId));
                    }
                }
                json.getOverrides().replaceAll(override -> {
                    ResourceLocation resolvedOverridePath;
                    String[] modelIdPathSplit = override.getModel().getPath().split("/");
                    if ((override.getModel().getPath().startsWith("./") || modelIdPathSplit.length > 2 && modelIdPathSplit[1].equals("cit")) && (resolvedOverridePath = CITType.resolveAsset(id, override.getModel().getPath(), "models", ".json", Minecraft.getInstance().getResourceManager())) != null) {
                        return new ItemOverride(ResewnItemModelIdentifier.pack(resolvedOverridePath), override.getPredicates().collect(Collectors.toList()));
                    }
                    return override;
                });
                cir.setReturnValue((Object)json);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

