/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.defaults.cit.conditions;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import schm.shsupercm.citresewn.api.CITConditionContainer;
import schm.shsupercm.citresewn.cit.CITCondition;
import schm.shsupercm.citresewn.cit.CITContext;
import schm.shsupercm.citresewn.cit.builtin.conditions.IntegerCondition;
import schm.shsupercm.citresewn.cit.builtin.conditions.ListCondition;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionEnchantments;

public class ConditionEnchantmentLevels
extends ListCondition<EnchantmentLevelCondition> {
    public static final CITConditionContainer<ConditionEnchantmentLevels> CONTAINER = new CITConditionContainer<ConditionEnchantmentLevels>(ConditionEnchantmentLevels.class, ConditionEnchantmentLevels::new, "enchantment_levels", "enchantmentLevels");
    protected Set<ResourceLocation> enchantments = null;

    public ConditionEnchantmentLevels() {
        super(EnchantmentLevelCondition.class, EnchantmentLevelCondition::new);
    }

    @Override
    public Set<Class<? extends CITCondition>> siblingConditions() {
        return Set.of(ConditionEnchantments.class);
    }

    @Override
    public <T extends CITCondition> T modifySibling(T sibling) {
        if (sibling instanceof ConditionEnchantments) {
            ConditionEnchantments conditionEnchantments = (ConditionEnchantments)sibling;
            if (this.enchantments == null) {
                this.enchantments = new HashSet<ResourceLocation>();
                for (EnchantmentLevelCondition subCondition : (EnchantmentLevelCondition[])this.conditions) {
                    subCondition.enchantments = this.enchantments;
                }
            }
            this.enchantments.addAll(Arrays.asList(conditionEnchantments.getEnchantments()));
        }
        return sibling;
    }

    protected static class EnchantmentLevelCondition
    extends IntegerCondition {
        protected Set<ResourceLocation> enchantments = null;

        protected EnchantmentLevelCondition() {
            super(true, false, false);
        }

        @Override
        public boolean test(CITContext context) {
            for (Map.Entry<ResourceLocation, Integer> entry : context.enchantments().entrySet()) {
                if (this.enchantments != null && !this.enchantments.contains(entry.getKey()) || entry.getValue() == null || !(this.range ? this.min <= entry.getValue() && entry.getValue() <= this.max : entry.getValue() == this.min)) continue;
                return true;
            }
            return false;
        }
    }
}

