/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.defaults.cit.conditions;

import com.mojang.serialization.DynamicOps;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import schm.shsupercm.citresewn.CITResewn;
import schm.shsupercm.citresewn.api.CITConditionContainer;
import schm.shsupercm.citresewn.cit.CITCondition;
import schm.shsupercm.citresewn.cit.CITContext;
import schm.shsupercm.citresewn.cit.CITParsingException;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionNBT;
import schm.shsupercm.citresewn.pack.format.PropertyGroup;
import schm.shsupercm.citresewn.pack.format.PropertyKey;
import schm.shsupercm.citresewn.pack.format.PropertyValue;

public class ConditionComponents
extends CITCondition {
    public static final CITConditionContainer<ConditionComponents> CONTAINER = new CITConditionContainer<ConditionComponents>(ConditionComponents.class, ConditionComponents::new, "components", "component", "nbt");
    private DataComponentType<?> componentType;
    private String componentMetadata;
    private String matchValue;
    private ConditionNBT fallbackNBTCheck;

    @Override
    public void load(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        String componentId;
        Object metadata = value.keyMetadata();
        if (key.path().equals("nbt")) {
            if (((String)metadata).startsWith("display.Name")) {
                metadata = "minecraft:custom_name" + value.keyMetadata().substring("display.Name".length());
                CITResewn.logWarnLoading(properties.messageWithDescriptorOf("Using legacy nbt.display.Name", value.position()));
            } else if (((String)metadata).startsWith("display.Lore")) {
                metadata = "minecraft:lore" + value.keyMetadata().substring("display.Lore".length());
                CITResewn.logWarnLoading(properties.messageWithDescriptorOf("Using legacy nbt.display.Lore", value.position()));
            } else {
                throw new CITParsingException("NBT condition is not supported since 1.21", properties, value.position());
            }
        }
        if ((this.componentType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.tryParse((String)(componentId = ((String)(metadata = ((String)metadata).replace("~", "minecraft:"))).split("\\.")[0])))) == null) {
            throw new CITParsingException("Unknown component type \"" + componentId + "\"", properties, value.position());
        }
        if (((String)(metadata = ((String)metadata).substring(componentId.length()))).startsWith(".")) {
            metadata = ((String)metadata).substring(1);
        }
        this.componentMetadata = metadata;
        this.matchValue = value.value();
        this.fallbackNBTCheck = new ConditionNBT();
        String[] metadataNbtPath = ((String)metadata).split("\\.");
        if (metadataNbtPath.length == 1 && metadataNbtPath[0].isEmpty()) {
            metadataNbtPath = new String[]{};
        }
        this.fallbackNBTCheck.loadNbtCondition(value, properties, metadataNbtPath, this.matchValue);
    }

    @Override
    public boolean test(CITContext context) {
        Object stackComponent = context.stack.getComponents().get(this.componentType);
        if (stackComponent != null) {
            Component text;
            if (stackComponent instanceof Component && this.fallbackNBTCheck.testString(null, text = (Component)stackComponent, context)) {
                return true;
            }
            Tag fallbackComponentNBT = (Tag)this.componentType.codec().encodeStart((DynamicOps)context.world.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), stackComponent).getOrThrow();
            return this.fallbackNBTCheck.testPath(fallbackComponentNBT, 0, context);
        }
        return false;
    }
}

