/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.cit.builtin.conditions.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import schm.shsupercm.citresewn.api.CITConditionContainer;
import schm.shsupercm.citresewn.cit.CIT;
import schm.shsupercm.citresewn.cit.builtin.conditions.IdentifierCondition;
import schm.shsupercm.citresewn.pack.format.PropertyValue;

public class FallbackCondition
extends IdentifierCondition {
    public static final CITConditionContainer<FallbackCondition> CONTAINER = new CITConditionContainer<FallbackCondition>(FallbackCondition.class, FallbackCondition::new, "cit_fallback", "citFallback");
    private static boolean fallbackCITResewnRoot = false;

    public FallbackCondition() {
        this.value = null;
    }

    public ResourceLocation getFallback() {
        return this.value;
    }

    public void setFallback(ResourceLocation value) {
        this.value = value;
    }

    public static void globalProperty(String key, PropertyValue value) throws Exception {
        if (key.equals("root_fallback")) {
            fallbackCITResewnRoot = value != null && Boolean.parseBoolean(value.value());
        }
    }

    public static void apply(List<CIT<?>> cits) {
        HashMap<String, Set> removePacks = new HashMap<String, Set>();
        for (CIT<?> cit2 : cits) {
            Set remove = removePacks.computeIfAbsent(cit2.packName, s -> new HashSet());
            if (cit2.fallback == null) {
                if (!fallbackCITResewnRoot || !cit2.propertiesIdentifier.getPath().startsWith("citresewn/")) continue;
                String subPath = cit2.propertiesIdentifier.getPath().substring(10);
                remove.add(ResourceLocation.fromNamespaceAndPath((String)cit2.propertiesIdentifier.getNamespace(), (String)("optifine/" + subPath)));
                remove.add(ResourceLocation.fromNamespaceAndPath((String)cit2.propertiesIdentifier.getNamespace(), (String)("mcpatcher/" + subPath)));
                continue;
            }
            remove.add(cit2.fallback);
        }
        cits.removeIf(cit -> {
            Set remove = (Set)removePacks.get(cit.packName);
            return remove != null && remove.contains(cit.propertiesIdentifier);
        });
    }
}

