/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.cit;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import schm.shsupercm.citresewn.CITResewn;
import schm.shsupercm.citresewn.api.CITConditionContainer;
import schm.shsupercm.citresewn.api.CITTypeContainer;
import schm.shsupercm.citresewn.cit.CITCondition;
import schm.shsupercm.citresewn.cit.CITParsingException;
import schm.shsupercm.citresewn.cit.CITType;
import schm.shsupercm.citresewn.cit.UnknownCITTypeException;
import schm.shsupercm.citresewn.cit.builtin.conditions.ConstantCondition;
import schm.shsupercm.citresewn.pack.format.PropertyGroup;
import schm.shsupercm.citresewn.pack.format.PropertyKey;
import schm.shsupercm.citresewn.pack.format.PropertyValue;
import schm.shsupercm.citresewn.platform.Services;

public final class CITRegistry {
    public static final Map<ResourceLocation, CITTypeContainer<? extends CITType>> TYPES = new HashMap<ResourceLocation, CITTypeContainer<? extends CITType>>();
    public static final Map<PropertyKey, CITConditionContainer<? extends CITCondition>> CONDITIONS = new HashMap<PropertyKey, CITConditionContainer<? extends CITCondition>>();
    private static final Map<Class<? extends CITType>, ResourceLocation> TYPE_TO_ID = new IdentityHashMap<Class<? extends CITType>, ResourceLocation>();
    private static final Map<Class<? extends CITCondition>, PropertyKey> CONDITION_TO_ID = new IdentityHashMap<Class<? extends CITCondition>, PropertyKey>();

    private CITRegistry() {
    }

    public static void registerAll() {
        CITResewn.LOG.info("Registering CIT Conditions");
        Services.PLATFORM.registerCITTypes();
    }

    public static Map<Class<? extends CITType>, ResourceLocation> getTypeToId() {
        return TYPE_TO_ID;
    }

    public static Map<Class<? extends CITCondition>, PropertyKey> getConditionToId() {
        return CONDITION_TO_ID;
    }

    public static CITCondition parseCondition(PropertyKey key, PropertyValue value, PropertyGroup properties) throws CITParsingException {
        CITConditionContainer<? extends CITCondition> conditionContainer = CONDITIONS.get(key);
        if (conditionContainer == null) {
            CITResewn.logWarnLoading(properties.messageWithDescriptorOf("Unknown condition type \"" + key.toString() + "\"", value.position()));
            return ConstantCondition.FALSE;
        }
        CITCondition condition = (CITCondition)conditionContainer.createCondition.get();
        condition.load(key, value, properties);
        return condition;
    }

    public static CITType parseType(PropertyGroup properties) throws UnknownCITTypeException {
        CITTypeContainer<? extends CITType> typeContainer;
        ResourceLocation type = ResourceLocation.fromNamespaceAndPath((String)"citresewn", (String)"item");
        PropertyValue propertiesType = properties.getLastWithoutMetadata("citresewn", "type");
        if (propertiesType != null) {
            Object value = propertiesType.value();
            if (!((String)value).contains(":")) {
                value = "citresewn:" + (String)value;
            }
            type = ResourceLocation.tryParse((String)value);
        }
        if ((typeContainer = TYPES.get(type)) == null) {
            throw new UnknownCITTypeException(properties, propertiesType == null ? -1 : propertiesType.position());
        }
        return (CITType)typeContainer.createType.get();
    }

    public static ResourceLocation idOfType(Class<? extends CITType> clazz) {
        return TYPE_TO_ID.get(clazz);
    }

    public static PropertyKey idOfCondition(Class<? extends CITCondition> clazz) {
        return CONDITION_TO_ID.get(clazz);
    }
}

