/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn.cit;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import schm.shsupercm.citresewn.api.CITTypeContainer;
import schm.shsupercm.citresewn.cit.CIT;
import schm.shsupercm.citresewn.cit.CITRegistry;
import schm.shsupercm.citresewn.cit.CITType;
import schm.shsupercm.citresewn.cit.builtin.conditions.core.FallbackCondition;
import schm.shsupercm.citresewn.cit.builtin.conditions.core.WeightCondition;
import schm.shsupercm.citresewn.config.CITResewnConfig;
import schm.shsupercm.citresewn.pack.GlobalProperties;
import schm.shsupercm.citresewn.pack.PackParser;
import schm.shsupercm.citresewn.platform.Services;

public class ActiveCITs {
    private static ActiveCITs active = null;
    public final GlobalProperties globalProperties = new GlobalProperties();
    public final Map<Class<? extends CITType>, List<CIT<?>>> cits = new IdentityHashMap();

    private ActiveCITs() {
    }

    public static ActiveCITs getActive() {
        return active;
    }

    public static boolean isActive() {
        return active != null;
    }

    public static void load(ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.push("citresewn:disposing");
        Services.PLATFORM.dispose();
        for (CITTypeContainer<? extends CITType> typeContainer : CITRegistry.TYPES.values()) {
            typeContainer.unload();
        }
        if (active != null) {
            ActiveCITs.active.globalProperties.properties.replaceAll((key, value) -> Set.of());
            ActiveCITs.active.globalProperties.callHandlers();
            active = null;
        }
        if (!CITResewnConfig.INSTANCE.enabled) {
            profiler.pop();
            return;
        }
        ActiveCITs active = new ActiveCITs();
        profiler.popPush("citresewn:load_global_properties");
        PackParser.loadGlobalProperties(resourceManager, active.globalProperties).callHandlers();
        profiler.popPush("citresewn:load_cits");
        List<CIT<?>> cits = PackParser.parseCITs(resourceManager);
        FallbackCondition.apply(cits);
        for (CIT<?> cIT : cits) {
            active.cits.computeIfAbsent(cIT.type.getClass(), type -> new ArrayList()).add(cIT);
        }
        block2: for (Map.Entry entry : active.cits.entrySet()) {
            WeightCondition.apply((List)entry.getValue());
            for (CITTypeContainer<? extends CITType> typeContainer : CITRegistry.TYPES.values()) {
                if (typeContainer.type != entry.getKey()) continue;
                typeContainer.loadUntyped((List)entry.getValue());
                continue block2;
            }
        }
        profiler.pop();
        if (!cits.isEmpty()) {
            ActiveCITs.active = active;
        }
    }
}

