/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import schm.shsupercm.citresewn.CITResewn;
import schm.shsupercm.citresewn.api.CITConditionContainer;
import schm.shsupercm.citresewn.api.CITDisposable;
import schm.shsupercm.citresewn.api.CITGlobalProperties;
import schm.shsupercm.citresewn.api.CITTypeContainer;
import schm.shsupercm.citresewn.cit.CITCondition;
import schm.shsupercm.citresewn.cit.CITRegistry;
import schm.shsupercm.citresewn.cit.CITType;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionComponents;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionDamage;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionDamageMask;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionEnchantmentLevels;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionEnchantments;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionHand;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionItems;
import schm.shsupercm.citresewn.defaults.cit.conditions.ConditionStackSize;
import schm.shsupercm.citresewn.defaults.cit.types.TypeArmor;
import schm.shsupercm.citresewn.defaults.cit.types.TypeElytra;
import schm.shsupercm.citresewn.defaults.cit.types.TypeEnchantment;
import schm.shsupercm.citresewn.defaults.cit.types.TypeItem;
import schm.shsupercm.citresewn.pack.format.PropertyKey;
import schm.shsupercm.citresewn.pack.format.PropertyValue;

public class Shim {
    public static final Map<ResourceLocation, CITTypeContainer<?>> TYPE = new HashMap();
    public static final Map<ResourceLocation, CITGlobalProperties> GLOBAL_PROPERTY = new HashMap<ResourceLocation, CITGlobalProperties>();
    public static final Map<ResourceLocation, CITConditionContainer<?>> CONDITION = new HashMap();
    public static final Set<CITDisposable> DISPOSABLES = new HashSet<CITDisposable>();

    public static void initTypes() {
        CITResewn.info("Registering CIT Types");
        TYPE.forEach((id, citTypeContainer) -> {
            CITRegistry.TYPES.put((ResourceLocation)id, (CITTypeContainer<? extends CITType>)citTypeContainer);
            CITRegistry.getTypeToId().putIfAbsent((Class<? extends CITType>)((CITType)citTypeContainer.createType.get()).getClass(), (ResourceLocation)id);
        });
    }

    public static void initConditions() {
        CONDITION.forEach((location, citConditionContainer) -> {
            for (String alias : citConditionContainer.aliases) {
                PropertyKey key = new PropertyKey(location.getNamespace(), alias);
                CITRegistry.CONDITIONS.put(key, (CITConditionContainer<? extends CITCondition>)citConditionContainer);
                CITRegistry.getConditionToId().putIfAbsent(((CITCondition)citConditionContainer.createCondition.get()).getClass(), key);
            }
        });
    }

    public static void initGlobalProperties(Map<PropertyKey, Set<PropertyValue>> properties) {
        GLOBAL_PROPERTY.forEach((location, citGlobalProperties) -> {
            String containerNamespace = "citresewn";
            for (Map.Entry entry : properties.entrySet()) {
                if (!((PropertyKey)entry.getKey()).namespace().equals(containerNamespace)) continue;
                PropertyValue lastValue = null;
                Iterator iterator = ((Set)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    PropertyValue value;
                    lastValue = value = (PropertyValue)iterator.next();
                }
                try {
                    citGlobalProperties.globalProperty(((PropertyKey)entry.getKey()).path(), lastValue);
                }
                catch (Exception e) {
                    CITResewn.logErrorLoading((String)(lastValue == null ? "Errored while disposing global properties" : "Errored while parsing global properties: Line " + lastValue.position() + " of " + String.valueOf(lastValue.propertiesIdentifier()) + " in " + lastValue.packName()));
                    e.printStackTrace();
                }
            }
        });
    }

    public static void initDispose() {
        DISPOSABLES.forEach(CITDisposable::dispose);
    }

    static {
        TYPE.put(CITResewn.id("armor"), TypeArmor.CONTAINER);
        TYPE.put(CITResewn.id("elytra"), TypeElytra.CONTAINER);
        TYPE.put(CITResewn.id("enchantment"), TypeEnchantment.CONTAINER);
        TYPE.put(CITResewn.id("item"), TypeItem.CONTAINER);
        CONDITION.put(CITResewn.id("component"), ConditionComponents.CONTAINER);
        CONDITION.put(CITResewn.id("damage"), ConditionDamage.CONTAINER);
        CONDITION.put(CITResewn.id("damage_mask"), ConditionDamageMask.CONTAINER);
        CONDITION.put(CITResewn.id("enchantment_levels"), ConditionEnchantmentLevels.CONTAINER);
        CONDITION.put(CITResewn.id("enchantments"), ConditionEnchantments.CONTAINER);
        CONDITION.put(CITResewn.id("hand"), ConditionHand.CONTAINER);
        CONDITION.put(CITResewn.id("items"), ConditionItems.CONTAINER);
        CONDITION.put(CITResewn.id("stack_size"), ConditionStackSize.CONTAINER);
        GLOBAL_PROPERTY.put(CITResewn.id("default"), TypeEnchantment.CONTAINER);
        DISPOSABLES.add(TypeArmor.CONTAINER);
        DISPOSABLES.add(TypeElytra.CONTAINER);
        DISPOSABLES.add(TypeItem.CONTAINER);
        DISPOSABLES.add(TypeEnchantment.CONTAINER);
    }
}

