/*
 * Decompiled with CFR 0.152.
 */
package schm.shsupercm.citresewn;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import schm.shsupercm.citresewn.cit.ActiveCITs;
import schm.shsupercm.citresewn.cit.CITRegistry;
import schm.shsupercm.citresewn.pack.format.PropertyKey;
import schm.shsupercm.citresewn.pack.format.PropertyValue;

public class CITResewnCommandCommon {
    public static int analyze(CommandContext<CommandSourceStack> context) {
        String pack = (String)context.getArgument("pack", String.class);
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (ActiveCITs.isActive()) {
            List conditions;
            source.sendSystemMessage(Component.nullToEmpty((String)("Analyzed CIT data of \"" + pack + "\u00a7r\":")));
            ArrayList<Component> builder = new ArrayList<Component>();
            for (Map.Entry entry : ActiveCITs.getActive().globalProperties.properties.entrySet()) {
                for (PropertyValue value : (Set)entry.getValue()) {
                    if (!value.packName().equals(pack)) continue;
                    builder.add(Component.nullToEmpty((String)("  " + ((PropertyKey)entry.getKey()).toString() + (String)(value.keyMetadata() == null ? "" : "." + value.keyMetadata()) + " = " + value.value())));
                }
            }
            if (!builder.isEmpty()) {
                source.sendSystemMessage(Component.nullToEmpty((String)" Global Properties:"));
                for (Component component : builder) {
                    source.sendSystemMessage(component);
                }
                builder.clear();
            }
            for (Map.Entry<Object, Object> entry : ActiveCITs.getActive().cits.entrySet()) {
                long count;
                if (((List)entry.getValue()).isEmpty() || (count = ((List)entry.getValue()).stream().filter(cit -> cit.packName.equals(pack)).count()) <= 0L) continue;
                builder.add(Component.nullToEmpty((String)("  " + CITRegistry.idOfType((Class)entry.getKey()).toString() + " = " + count)));
            }
            if (!builder.isEmpty()) {
                source.sendSystemMessage(Component.nullToEmpty((String)" Types:"));
                for (Component component : builder) {
                    source.sendSystemMessage(component);
                }
                builder.clear();
            }
            if (!(conditions = ActiveCITs.getActive().cits.values().stream().flatMap(Collection::stream).filter(cit -> cit.packName.equals(pack)).flatMap(cit -> Arrays.stream(cit.conditions)).toList()).isEmpty()) {
                source.sendSystemMessage(Component.nullToEmpty((String)(" Utilizing " + conditions.size() + " conditions(" + conditions.stream().map(Object::getClass).distinct().count() + " unique condition types)")));
            }
        } else {
            source.sendSystemMessage(Component.nullToEmpty((String)"Not active"));
        }
        return 1;
    }

    public static class LoadedCITPackArgument
    implements ArgumentType<String> {
        public String parse(StringReader reader) throws CommandSyntaxException {
            StringBuilder builder = new StringBuilder();
            while (reader.canRead()) {
                builder.append(reader.read());
            }
            String pack = builder.toString().trim();
            if (!LoadedCITPackArgument.getPacks().contains(pack)) {
                LiteralMessage message = new LiteralMessage("Could not find CIT pack");
                throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
            }
            return pack;
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return CompletableFuture.supplyAsync(() -> {
                for (String pack : LoadedCITPackArgument.getPacks()) {
                    builder.suggest(pack);
                }
                return builder.build();
            });
        }

        private static Set<String> getPacks() {
            if (ActiveCITs.isActive()) {
                return ActiveCITs.getActive().cits.values().stream().flatMap(Collection::stream).map(cit -> cit.packName).collect(Collectors.toSet());
            }
            return Collections.emptySet();
        }
    }
}

