/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.math;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.math.ScreenPos;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class MathUtils {
    private MathUtils() {
    }

    public static ScreenPos worldToScreen(Vec3 worldPos, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        Window window = CommonClient.Game.getWindow();
        Camera camera = CommonClient.Game.gameRenderer.getMainCamera();
        Vector4f worldPosRel = new Vector4f((Vector3fc)camera.getPosition().reverse().add(worldPos).toVector3f(), 1.0f);
        worldPosRel.mul((Matrix4fc)modelViewMatrix);
        worldPosRel.mul((Matrix4fc)projectionMatrix);
        float depth = worldPosRel.w;
        if (depth != 0.0f) {
            worldPosRel.div(depth);
        }
        return new ScreenPos((float)window.getGuiScaledWidth() * (0.5f + worldPosRel.x * 0.5f), (float)window.getGuiScaledHeight() * (0.5f - worldPosRel.y * 0.5f), depth);
    }

    public static void rotateZ(PoseStack matrixStack, float theta) {
        matrixStack.mulPose(new Matrix4f().rotateZ(theta));
    }

    public static Vec2 calculateAngleRectIntersection(float angle, Vec2 leftTop, Vec2 rightBottom) {
        Vec3 direction = new Vec3(Math.cos(angle), Math.sin(angle), 0.0);
        float width = rightBottom.x - leftTop.x;
        float height = rightBottom.y - leftTop.y;
        direction = direction.multiply(new Vec3((double)(1.0f / width), (double)(1.0f / height), 0.0));
        double dx = Math.cos(angle);
        double dy = Math.sin(angle);
        float cx = width * 0.5f;
        float cy = height * 0.5f;
        if (Math.abs(direction.x) < Math.abs(direction.y)) {
            if (direction.y < 0.0) {
                double t = (double)(-cy) / dy;
                double x = (double)cx + t * dx;
                return new Vec2((float)x + leftTop.x, leftTop.y);
            }
            double t = (double)cy / dy;
            double x = (double)cx + t * dx;
            return new Vec2((float)x + leftTop.x, rightBottom.y);
        }
        if (direction.x < 0.0) {
            double t = (double)(-cx) / dx;
            double y = (double)cy + t * dy;
            return new Vec2(leftTop.x, (float)y + leftTop.y);
        }
        double t = (double)cx / dx;
        double y = (double)cy + t * dy;
        return new Vec2(rightBottom.x, (float)y + leftTop.y);
    }
}

