/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.config.ChannelMode;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.integration.TeamContextHandler;
import nx.pingwheel.common.network.PingLocationC2SPacket;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;
import nx.pingwheel.common.util.RateLimiter;

public class ServerCore {
    private static final ServerConfig SERVER_CONFIG = ServerConfig.HANDLER.getConfig();
    private static final HashMap<UUID, String> PLAYER_CHANNELS = new HashMap();
    private static final HashMap<UUID, RateLimiter> PLAYER_RATES = new HashMap();

    private ServerCore() {
    }

    public static void init() {
        RateLimiter.setRates(SERVER_CONFIG.getMsToRegenerate(), SERVER_CONFIG.getRateLimit());
    }

    public static void onPlayerDisconnect(ServerPlayer player) {
        PLAYER_CHANNELS.remove(player.getUUID());
        PLAYER_RATES.remove(player.getUUID());
    }

    public static void onChannelUpdate(ServerPlayer player, UpdateChannelC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid channel update from %s (%s)".formatted(player.getGameProfile().getName(), player.getUUID()));
            player.displayClientMessage((Component)Component.literal((String)("\u00a78[Ping-Wheel] \u00a7cChannel couldn't be updated\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.MOD_VERSION)), false);
            return;
        }
        ServerCore.updatePlayerChannel(player, packet.channel());
    }

    public static void onPingLocation(MinecraftServer server, ServerPlayer player, PingLocationC2SPacket packet) {
        if (packet.isCorrupt()) {
            Global.LOGGER.warn(() -> "invalid ping location from %s (%s)".formatted(player.getGameProfile().getName(), player.getUUID()));
            player.displayClientMessage((Component)Component.literal((String)("\u00a78[Ping-Wheel] \u00a7cUnable to send ping\n\u00a7fMake sure your version matches the server's version: \u00a7d" + Global.MOD_VERSION)), false);
            return;
        }
        PLAYER_RATES.putIfAbsent(player.getUUID(), new RateLimiter());
        RateLimiter rateLimiter = PLAYER_RATES.get(player.getUUID());
        if (SERVER_CONFIG.getRateLimit() > 0 && rateLimiter.checkExceeded()) {
            return;
        }
        String channel = packet.channel();
        ChannelMode defaultChannelMode = SERVER_CONFIG.getDefaultChannelMode();
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.DISABLED) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (channel.isEmpty() && defaultChannelMode == ChannelMode.TEAM_ONLY && !TeamContextHandler.hasTeam((Player)player)) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a78[Ping-Wheel] \u00a7eMust be in a team or channel to ping location\n\u00a7fUse \u00a7a/pingwheel channel\u00a7f to switch"), false);
            return;
        }
        if (!channel.equals(PLAYER_CHANNELS.getOrDefault(player.getUUID(), ""))) {
            ServerCore.updatePlayerChannel(player, channel);
        }
        PlayerList playerList = server.getPlayerList();
        PingLocationS2CPacket packetOut = !SERVER_CONFIG.isPlayerTrackingEnabled() && ServerCore.targetEntityIsPlayer(packet, playerList) ? new PingLocationS2CPacket(packet.channel(), packet.pos(), null, packet.sequence(), packet.dimension(), player.getUUID()) : PingLocationS2CPacket.fromClientPacket(packet, player.getUUID());
        for (ServerPlayer p : playerList.getPlayers()) {
            if (!channel.equals(PLAYER_CHANNELS.getOrDefault(p.getUUID(), "")) || channel.isEmpty() && defaultChannelMode != ChannelMode.GLOBAL && !TeamContextHandler.inSameContext((Player)player, (Player)p)) continue;
            IPlatformNetworkService.INSTANCE.sendToClient(packetOut, p);
        }
    }

    private static boolean targetEntityIsPlayer(PingLocationC2SPacket packet, PlayerList playerList) {
        UUID playerUUID = packet.entity();
        if (playerUUID == null) {
            return false;
        }
        return playerList.getPlayer(playerUUID) != null;
    }

    private static void updatePlayerChannel(ServerPlayer player, String channel) {
        if (channel.isEmpty()) {
            PLAYER_CHANNELS.remove(player.getUUID());
            Global.LOGGER.info(() -> "Channel update: %s -> default".formatted(player.getGameProfile().getName()));
        } else {
            PLAYER_CHANNELS.put(player.getUUID(), channel);
            Global.LOGGER.info(() -> "Channel update: %s -> \"%s\"".formatted(player.getGameProfile().getName(), channel));
        }
    }
}

