/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import snownee.kiwi.customization.CustomizationRegistries;

public interface BuilderRule {
    public static final Codec<BuilderRule> CODEC = Codec.lazyInitialized(() -> CustomizationRegistries.BUILDER_RULE.byNameCodec().dispatch(BuilderRule::type, Type::codec));

    public Type<?> type();

    public Stream<Block> relatedBlocks();

    public boolean matches(Player var1, ItemStack var2, BlockState var3);

    public void apply(UseOnContext var1, List<BlockPos> var2);

    public List<BlockPos> searchPositions(BlockState var1, UseOnContext var2);

    default public void playPlaceSound(Player player, BlockState blockState) {
        SoundType soundType = blockState.getSoundType();
        player.level().playSound(null, player.blockPosition(), soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }

    public record Type<T extends BuilderRule>(MapCodec<T> codec) {
    }
}

