/*
 * Decompiled with CFR 0.152.
 */
package toni.randomenchantfix;

import java.util.List;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.randomenchantfix.foundation.config.AllConfigs;

@Mod(value="randomenchantfix")
public class RandomEnchantFix {
    public static final String MODNAME = "Random Enchant Fix";
    public static final String ID = "randomenchantfix";
    public static final Logger LOGGER = LogManager.getLogger((String)"Random Enchant Fix");
    public static List<String> ALWAYS_FILTERED = List.of("nova_structures:shulker_boss", "nova_structures:shulker_miniboss", "nova_structures:boss_behaviour");

    public RandomEnchantFix(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        AllConfigs.register((type, spec) -> modContainer.registerConfig(type, (IConfigSpec)spec));
    }

    public static void filterEnchants(List<EnchantmentInstance> list) {
        if (list.isEmpty()) {
            return;
        }
        list.removeIf(item -> ALWAYS_FILTERED.contains(item.enchantment.getRegisteredName()));
        list.removeIf(item -> ((List)AllConfigs.common().FILTERED_ENCHANTMENTS.get()).contains(item.enchantment.getRegisteredName()));
    }

    public void onInitialize() {
    }

    public void onInitializeClient() {
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        this.onInitialize();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.onInitializeClient();
    }
}

