/*
 * Decompiled with CFR 0.152.
 */
package toni.cerulean.mixin;

import java.util.Optional;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import toni.cerulean.iface.IItemPredicateMixin;
import toni.cerulean.iface.IItemStackMixin;
import toni.cerulean.util.LogHelper;

@Mixin(value={ItemPredicate.class})
public abstract class ItemPredicateMixin
implements IItemPredicateMixin {
    @Final
    @Shadow
    private MinMaxBounds.Ints count;

    @Shadow
    public abstract boolean test(ItemStack var1);

    @Override
    public boolean cerulean$fasterMatches(ItemStack itemStack) {
        Optional minThr = this.count.min();
        Optional maxThr = this.count.max();
        int stackCount = itemStack.getCount();
        int prevStackCount = ((IItemStackMixin)itemStack).cerulean$getPreviousStackSize();
        LogHelper.debug(() -> "Checking stack %d for range [%d; %d]".formatted(stackCount, minThr.orElse(null), maxThr.orElse(null)));
        if (minThr.map(integer -> prevStackCount < integer && integer <= stackCount).orElseGet(() -> prevStackCount == 0).booleanValue() && (maxThr.isEmpty() || stackCount <= (Integer)maxThr.get())) {
            return this.test(itemStack);
        }
        return false;
    }
}

