/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.client.screen;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class ConfigScreen
extends Screen {
    private final Component modTitle;
    private final Screen parent;
    private final MutableComponent configured = Component.literal((String)"Configured").withStyle(ChatFormatting.YELLOW);

    public ConfigScreen(Component title, Screen parent) {
        super((Component)Component.translatable((String)"fml.menu.mods.config").append(" / ").append(title));
        this.modTitle = title;
        this.parent = parent;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"config.advancednetherite.screen.button.install_configured", (Object[])new Object[]{this.configured}), onPress -> this.handleComponentClicked(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured")))).pos(this.width / 2 - 155, this.height / 2 + 12).size(150, 20).build());
        Button instructionsButton = Button.builder((Component)Component.translatable((String)"config.advancednetherite.screen.button.instructions"), onPress -> {
            if (this.getInstructionsUrl() != null) {
                this.handleComponentClicked(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.getInstructionsUrl())));
            }
        }).pos(this.width / 2 + 5, this.height / 2 + 12).size(150, 20).build();
        if (this.getInstructionsUrl() == null) {
            instructionsButton.active = false;
        }
        this.addRenderableWidget((GuiEventListener)instructionsButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, onPress -> this.minecraft.setScreen(this.parent)).pos(this.width / 2 - 75, this.height - 29).size(150, 20).build());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float ticks) {
        this.renderBackground(graphics, mouseX, mouseY, ticks);
        super.render(graphics, mouseX, mouseY, ticks);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 7, 0xFFFFFF);
        ConfigScreen.drawCenteredSplitString(graphics, this.font, this.font.split((FormattedText)this.getDescriptionTop(), this.width), this.width / 2, 55, 0xFFFFFF);
        ConfigScreen.drawCenteredSplitString(graphics, this.font, this.font.split((FormattedText)this.getDescriptionBottom(), this.width), this.width / 2, 90, 0xFFFFFF);
    }

    public static void drawCenteredSplitString(GuiGraphics graphics, Font font, List<FormattedCharSequence> charSequenceList, int x, int y, int color) {
        for (FormattedCharSequence sequence : charSequenceList) {
            graphics.drawCenteredString(font, sequence, x, y, color);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public Component getDescriptionTop() {
        return Component.translatable((String)"config.advancednetherite.screen.description.top", (Object[])new Object[]{this.configured, this.modTitle});
    }

    public Component getDescriptionBottom() {
        return Component.translatable((String)"config.advancednetherite.screen.description.bottom");
    }

    public String getInstructionsUrl() {
        return "https://github.com/Autovw/AdvancedNetherite/wiki/Configuration";
    }
}

