/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import com.faboslav.variantsandventures.common.util.AdvancementHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class VerdantEntity
extends Skeleton {
    public VerdantEntity(EntityType<? extends Skeleton> entityType, Level world) {
        super(entityType, world);
    }

    protected SoundEvent getAmbientSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_AMBIENT.get();
    }

    public void playAmbientSound() {
        SoundEvent soundEvent = this.getAmbientSound();
        if (soundEvent != null) {
            this.playSound(soundEvent, 0.25f, this.getVoicePitch());
        }
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_VERDANT_DEATH.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(VariantsAndVenturesSoundEvents.ENTITY_VERDANT_STEP.get(), 0.15f, 1.0f);
    }

    public void tick() {
        if (!VariantsAndVentures.getConfig().enableVerdant) {
            this.discard();
        }
        super.tick();
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        ItemStack possibleBow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
        if (!possibleBow.is(Items.BOW)) {
            return;
        }
        ItemStack possibleProjectile = this.getProjectile(possibleBow);
        if (possibleProjectile == ItemStack.EMPTY) {
            return;
        }
        AbstractArrow abstractArrow = this.getArrow(possibleProjectile, velocity, possibleBow);
        double d = target.getX() - this.getX();
        double e = target.getY(0.3333333333333333) - abstractArrow.getY();
        double f = target.getZ() - this.getZ();
        double g = Math.sqrt(d * d + f * f);
        abstractArrow.shoot(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.level().addFreshEntity((Entity)abstractArrow);
        this.playSound(VariantsAndVenturesSoundEvents.ENTITY_VERDANT_ATTACK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
    }

    protected AbstractArrow getArrow(ItemStack arrow, float damageModifier, @Nullable ItemStack shotFrom) {
        AbstractArrow persistentProjectileEntity = super.getArrow(arrow, damageModifier, shotFrom);
        if (persistentProjectileEntity instanceof Arrow) {
            ((Arrow)persistentProjectileEntity).addEffect(new MobEffectInstance(MobEffects.POISON, 100));
        }
        return persistentProjectileEntity;
    }

    public boolean isFreezeConverting() {
        return false;
    }

    public boolean isShaking() {
        return false;
    }

    protected void doFreezeConversion() {
    }

    public boolean canFreeze() {
        return false;
    }

    public void die(DamageSource damageSource) {
        super.die(damageSource);
        AdvancementHelper.triggerMonsterHunter(this.level(), damageSource);
    }
}

