/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.render.entity;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.model.ThicketEntityModel;
import com.faboslav.variantsandventures.common.client.render.entity.feature.ThicketOverlayFeatureRenderer;
import com.faboslav.variantsandventures.common.entity.mob.ThicketEntity;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ThicketEntityRenderer
extends AbstractZombieRenderer<ThicketEntity, ThicketEntityModel<ThicketEntity>> {
    public static final ResourceLocation TEXTURE = VariantsAndVentures.makeID("textures/entity/thicket/thicket.png");

    public ThicketEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new ThicketEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.THICKET)), new ThicketEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.THICKET_INNER_ARMOR)), new ThicketEntityModel(context.bakeLayer(VariantsAndVenturesModelLayers.THICKET_OUTER_ARMOR)));
        this.addLayer(new ThicketOverlayFeatureRenderer(this, context.getModelSet()));
    }

    public ResourceLocation getTextureLocation(ThicketEntity thicket) {
        return TEXTURE;
    }

    protected void setupRotations(ThicketEntity thicket, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        super.setupRotations((LivingEntity)thicket, matrices, animationProgress, bodyYaw, tickDelta, scale);
        float h = thicket.getSwimAmount(tickDelta);
        if (h > 0.0f) {
            float angle = Mth.lerp((float)h, (float)thicket.getXRot(), (float)(-10.0f - thicket.getXRot()));
            matrices.mulPose(Axis.XP.rotationDegrees(angle));
        }
    }
}

